/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ByteProcessor;
import io.netty.util.ByteString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
extends ByteString
implements CharSequence,
Comparable<CharSequence> {
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final AsciiString EMPTY_STRING = new AsciiString("");
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.caseInsensitiveHashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };
    private static final ByteString.ByteStringFactory DEFAULT_FACTORY = new ByteString.ByteStringFactory(){

        @Override
        public ByteString newInstance(byte[] value, int start, int length, boolean copy) {
            return new AsciiString(value, start, length, copy);
        }
    };
    private String string;
    private int caseInsensitiveHash;

    public static AsciiString of(CharSequence string) {
        return string instanceof AsciiString ? (AsciiString)string : new AsciiString(string);
    }

    public AsciiString(byte[] value) {
        super(value);
    }

    public AsciiString(byte[] value, boolean copy) {
        super(value, copy);
    }

    public AsciiString(byte[] value, int start, int length, boolean copy) {
        super(value, start, length, copy);
    }

    public AsciiString(ByteString value, boolean copy) {
        super(value, copy);
    }

    public AsciiString(ByteBuffer value) {
        super(value);
    }

    public AsciiString(ByteBuffer value, int start, int length, boolean copy) {
        super(value, start, length, copy);
    }

    public AsciiString(char[] value) {
        this(ObjectUtil.checkNotNull(value, "value"), 0, value.length);
    }

    public AsciiString(char[] value, int start, int length) {
        super(length);
        if (start < 0 || start > ObjectUtil.checkNotNull(value, "value").length - length) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
        }
        int i = 0;
        int j = start;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value[j]);
            ++i;
            ++j;
        }
    }

    public AsciiString(CharSequence value) {
        this(ObjectUtil.checkNotNull(value, "value"), 0, value.length());
    }

    public AsciiString(CharSequence value, int start, int length) {
        super(length);
        if (start < 0 || length < 0 || length > ObjectUtil.checkNotNull(value, "value").length() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length() + ')');
        }
        int i = 0;
        int j = start;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value.charAt(j));
            ++i;
            ++j;
        }
    }

    @Override
    public char charAt(int index) {
        return (char)(this.byteAt(index) & 0xFF);
    }

    @Override
    public void arrayChanged() {
        this.string = null;
        this.caseInsensitiveHash = 0;
        super.arrayChanged();
    }

    @Override
    public String toString(Charset charset, int start, int end) {
        if (start == 0 && end == this.length()) {
            if (this.string == null) {
                this.string = super.toString(charset, start, end);
            }
            return this.string;
        }
        return super.toString(charset, start, end);
    }

    @Override
    public int compareTo(CharSequence string) {
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        int i = 0;
        int j = this.arrayOffset();
        while (i < minLength) {
            int result = (char)(this.value[j] & 0xFF) - string.charAt(i);
            if (result != 0) {
                return result;
            }
            ++i;
            ++j;
        }
        return length1 - length2;
    }

    public AsciiString concat(CharSequence string) {
        int thisLen = this.length();
        int thatLen = string.length();
        if (thatLen == 0) {
            return this;
        }
        if (string instanceof AsciiString) {
            AsciiString that = (AsciiString)string;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = new byte[thisLen + thatLen];
            System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
            System.arraycopy(that.value, that.arrayOffset(), newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string);
        }
        byte[] newValue = new byte[thisLen + thatLen];
        System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
        int i = thisLen;
        int j = 0;
        while (i < newValue.length) {
            newValue[i] = AsciiString.c2b(string.charAt(j));
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean contentEqualsIgnoreCase(CharSequence string) {
        if (string == null || string.length() != this.length()) {
            return false;
        }
        if (string.getClass() == AsciiString.class) {
            AsciiString rhs = (AsciiString)string;
            int i = this.arrayOffset();
            int j = rhs.arrayOffset();
            while (i < this.length()) {
                if (!AsciiString.equalsIgnoreCase(this.value[i], this.value[j])) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        int i = this.arrayOffset();
        int j = 0;
        while (i < this.length()) {
            if (!AsciiString.equalsIgnoreCase((char)(this.value[i] & 0xFF), string.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int start, int end) {
        int length = end - start;
        if (length == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (start < 0 || length > this.length() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        char[] buffer = new char[length];
        int i = 0;
        int j = start + this.arrayOffset();
        while (i < length) {
            buffer[i] = (char)(this.value[j] & 0xFF);
            ++i;
            ++j;
        }
        return buffer;
    }

    public void copy(int srcIdx, char[] dst, int dstIdx, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (srcIdx < 0 || length > this.length() - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        int dstEnd = dstIdx + length;
        int i = dstIdx;
        int j = srcIdx + this.arrayOffset();
        while (i < dstEnd) {
            dst[i] = (char)(this.value[j] & 0xFF);
            ++i;
            ++j;
        }
    }

    @Override
    public AsciiString subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public AsciiString subSequence(int start, int end) {
        return this.subSequence(start, end, true);
    }

    @Override
    public AsciiString subSequence(int start, int end, boolean copy) {
        return (AsciiString)super.subSequence(start, end, copy, DEFAULT_FACTORY);
    }

    public int indexOf(CharSequence string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(CharSequence subString, int start) {
        if (start < 0) {
            start = 0;
        }
        int thisLen = this.length();
        int subCount = subString.length();
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        if (subCount > thisLen - start) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        ByteProcessor.IndexOfProcessor IndexOfVisitor = new ByteProcessor.IndexOfProcessor((byte)firstChar);
        try {
            while (true) {
                int i;
                if ((i = this.forEachByte(start, thisLen - start, IndexOfVisitor)) == -1 || subCount + i > thisLen) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && (char)(this.value[++o1 + this.arrayOffset()] & 0xFF) == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    public int lastIndexOf(CharSequence string) {
        return this.lastIndexOf(string, this.length());
    }

    public int lastIndexOf(CharSequence subString, int start) {
        int thisLen = this.length();
        int subCount = subString.length();
        if (subCount > thisLen || start < 0) {
            return -1;
        }
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        start = Math.min(start, thisLen - subCount);
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        ByteProcessor.IndexOfProcessor IndexOfVisitor = new ByteProcessor.IndexOfProcessor((byte)firstChar);
        try {
            while (true) {
                int i;
                if ((i = this.forEachByteDesc(start, thisLen - start, IndexOfVisitor)) == -1) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && (char)(this.value[++o1 + this.arrayOffset()] & 0xFF) == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i - 1;
            }
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return -1;
        }
    }

    public boolean regionMatches(int thisStart, CharSequence string, int start, int length) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thatEnd = start + length;
        int i = start;
        int j = thisStart + this.arrayOffset();
        while (i < thatEnd) {
            if ((char)(this.value[j] & 0xFF) != string.charAt(i)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        if (string == null) {
            throw new NullPointerException("string");
        }
        int thisLen = this.length();
        if (thisStart < 0 || length > thisLen - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int thisEnd = (thisStart += this.arrayOffset()) + length;
        while (thisStart < thisEnd) {
            if (AsciiString.equalsIgnoreCase((char)(this.value[thisStart++] & 0xFF), string.charAt(start++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char oldChar, char newChar) {
        int index;
        if (oldChar > '\u00ff') {
            return this;
        }
        byte oldCharByte = AsciiString.c2b(oldChar);
        try {
            index = this.forEachByte(new ByteProcessor.IndexOfProcessor(oldCharByte));
        }
        catch (Exception e) {
            PlatformDependent.throwException(e);
            return this;
        }
        if (index == -1) {
            return this;
        }
        byte newCharByte = AsciiString.c2b(newChar);
        byte[] buffer = new byte[this.length()];
        int i = 0;
        int j = this.arrayOffset();
        while (i < buffer.length) {
            byte b = this.value[j];
            if (b == oldCharByte) {
                b = newCharByte;
            }
            buffer[i] = b;
            ++i;
            ++j;
        }
        return new AsciiString(buffer, false);
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(CharSequence prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.length());
    }

    public AsciiString toLowerCase() {
        int i;
        boolean lowercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        byte[] newValue = new byte[this.length()];
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toLowerCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString toUpperCase() {
        int i;
        boolean uppercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 97 || b > 122) continue;
            uppercased = false;
            break;
        }
        if (uppercased) {
            return this;
        }
        byte[] newValue = new byte[this.length()];
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toUpperCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString trim() {
        int start;
        int last;
        int end = last = this.arrayOffset() + this.length();
        for (start = this.arrayOffset(); start <= end && this.value[start] <= 32; ++start) {
        }
        while (end >= start && this.value[end] <= 32) {
            --end;
        }
        if (start == 0 && end == last) {
            return this;
        }
        return new AsciiString(this.value, start, end - start + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        if (a.length() != this.length()) {
            return false;
        }
        int i = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if ((char)(this.value[i] & 0xFF) != a.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public AsciiString[] split(String expr, int max) {
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, max));
    }

    public AsciiString[] split(char delim) {
        int i;
        ArrayList<AsciiString> res = new ArrayList<AsciiString>();
        int start = 0;
        int length = this.length();
        for (i = start; i < length; ++i) {
            if (this.charAt(i) != delim) continue;
            if (start == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(this.value, start + this.arrayOffset(), i - start, false));
            }
            start = i + 1;
        }
        if (start == 0) {
            res.add(this);
        } else if (start != length) {
            res.add(new AsciiString(this.value, start + this.arrayOffset(), length - start, false));
        } else {
            for (i = res.size() - 1; i >= 0 && ((AsciiString)res.get(i)).isEmpty(); --i) {
                res.remove(i);
            }
        }
        return res.toArray(new AsciiString[res.size()]);
    }

    public int hashCodeCaseInsensitive() {
        int h = this.caseInsensitiveHash;
        if (h == 0) {
            int end = this.arrayOffset() + this.length();
            for (int i = this.arrayOffset(); i < end; ++i) {
                h = h * 31 + AsciiString.toLowerCase((char)(this.value[i] & 0xFF));
            }
            this.caseInsensitiveHash = h;
        }
        return this.caseInsensitiveHash;
    }

    public static int caseInsensitiveHashCode(CharSequence value) {
        if (value.getClass() == AsciiString.class) {
            return ((AsciiString)value).hashCodeCaseInsensitive();
        }
        int hash = 0;
        for (int i = 0; i < value.length(); ++i) {
            hash = hash * 31 + AsciiString.toLowerCase(value.charAt(i));
        }
        return hash;
    }

    public static int hashCode(CharSequence value) {
        if (value.getClass() == AsciiString.class) {
            return ((AsciiString)value).hashCode();
        }
        int hash = 0;
        for (int i = 0; i < value.length(); ++i) {
            hash = hash * 31 + value.charAt(i);
        }
        return hash;
    }

    public static boolean contains(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, CaseInsensativeCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() == AsciiString.class) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b.getClass() == AsciiString.class) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < a.length()) {
            if (!AsciiString.equalsIgnoreCase(a.charAt(i), b.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence value) {
        for (CharSequence v : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(value, v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            if (AsciiString.containsContentEqualsIgnoreCase(a, v)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() == AsciiString.class) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b.getClass() == AsciiString.class) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i = 0; i < jdkResult.length; ++i) {
            res[i] = new AsciiString(jdkResult[i]);
        }
        return res;
    }

    public boolean contains(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        return this.indexOf(cs) >= 0;
    }

    private static boolean contains(CharSequence a, CharSequence b, CharEqualityComparator cmp) {
        if (a == null || b == null || a.length() < b.length()) {
            return false;
        }
        if (b.length() == 0) {
            return true;
        }
        int bStart = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (cmp.equals(b.charAt(bStart), a.charAt(i))) {
                if (++bStart != b.length()) continue;
                return true;
            }
            if (a.length() - i < b.length()) {
                return false;
            }
            bStart = 0;
        }
        return false;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static byte toLowerCase(byte b) {
        if (65 <= b && b <= 90) {
            return (byte)(b + 32);
        }
        return b;
    }

    private static char toLowerCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private static byte toUpperCase(byte b) {
        if (97 <= b && b <= 122) {
            return (byte)(b - 32);
        }
        return b;
    }

    private static byte c2b(char c) {
        if (c > '\u00ff') {
            return 63;
        }
        return (byte)c;
    }

    private static final class CaseInsensativeCharEqualityComparator
    implements CharEqualityComparator {
        static final CaseInsensativeCharEqualityComparator INSTANCE = new CaseInsensativeCharEqualityComparator();

        private CaseInsensativeCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return AsciiString.equalsIgnoreCase(a, b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

