/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v5.Socks5AuthStatus;
import io.netty.handler.codec.socksx.v5.Socks5Response;
import io.netty.handler.codec.socksx.v5.Socks5ResponseType;
import io.netty.handler.codec.socksx.v5.Socks5SubnegotiationVersion;

public final class Socks5AuthResponse
extends Socks5Response {
    private static final Socks5SubnegotiationVersion SUBNEGOTIATION_VERSION = Socks5SubnegotiationVersion.AUTH_PASSWORD;
    private final Socks5AuthStatus authStatus;

    public Socks5AuthResponse(Socks5AuthStatus authStatus) {
        super(Socks5ResponseType.AUTH);
        if (authStatus == null) {
            throw new NullPointerException("authStatus");
        }
        this.authStatus = authStatus;
    }

    public Socks5AuthStatus authStatus() {
        return this.authStatus;
    }

    @Override
    void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(SUBNEGOTIATION_VERSION.byteValue());
        byteBuf.writeByte(this.authStatus.byteValue());
    }
}

