/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.util.Recycler;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class NioSocketChannelOutboundBuffer
extends ChannelOutboundBuffer {
    private ByteBuffer[] nioBuffers = new ByteBuffer[32];
    private int nioBufferCount;
    private long nioBufferSize;
    private static final Recycler<NioSocketChannelOutboundBuffer> RECYCLER = new Recycler<NioSocketChannelOutboundBuffer>(){

        @Override
        protected NioSocketChannelOutboundBuffer newObject(Recycler.Handle<NioSocketChannelOutboundBuffer> handle) {
            return new NioSocketChannelOutboundBuffer(handle);
        }
    };

    public static NioSocketChannelOutboundBuffer newInstance(AbstractChannel channel) {
        NioSocketChannelOutboundBuffer buffer = RECYCLER.get();
        buffer.channel = channel;
        return buffer;
    }

    private NioSocketChannelOutboundBuffer(Recycler.Handle<NioSocketChannelOutboundBuffer> handle) {
        super(handle);
    }

    @Override
    protected Object beforeAdd(Object msg) {
        ByteBuf buf;
        if (msg instanceof ByteBuf && !(buf = (ByteBuf)msg).isDirect()) {
            return this.copyToDirectByteBuf(buf);
        }
        return msg;
    }

    public ByteBuffer[] nioBuffers() {
        Object m;
        long nioBufferSize = 0L;
        int nioBufferCount = 0;
        ChannelOutboundBuffer.Entry[] buffer = this.entries();
        int mask = buffer.length - 1;
        ByteBuffer[] nioBuffers = this.nioBuffers;
        int unflushed = this.unflushed();
        int i = this.flushed();
        while (i != unflushed && (m = buffer[i].msg()) != null) {
            if (!(m instanceof ByteBuf)) {
                this.nioBufferCount = 0;
                this.nioBufferSize = 0L;
                return null;
            }
            NioEntry entry = (NioEntry)buffer[i];
            if (!entry.isCancelled()) {
                ByteBuf buf = (ByteBuf)m;
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if (readableBytes > 0) {
                    int neededSpace;
                    nioBufferSize += (long)readableBytes;
                    int count = entry.count;
                    if (count == -1) {
                        entry.count = count = buf.nioBufferCount();
                    }
                    if ((neededSpace = nioBufferCount + count) > nioBuffers.length) {
                        nioBuffers = NioSocketChannelOutboundBuffer.expandNioBufferArray(nioBuffers, neededSpace, nioBufferCount);
                        this.nioBuffers = nioBuffers;
                    }
                    if (count == 1) {
                        ByteBuffer nioBuf = entry.buf;
                        if (nioBuf == null) {
                            entry.buf = nioBuf = buf.internalNioBuffer(readerIndex, readableBytes);
                        }
                        nioBuffers[nioBufferCount++] = nioBuf;
                    } else {
                        ByteBuffer[] nioBufs = entry.buffers;
                        if (nioBufs == null) {
                            nioBufs = buf.nioBuffers();
                            entry.buffers = nioBufs;
                        }
                        nioBufferCount = NioSocketChannelOutboundBuffer.fillBufferArray(nioBufs, nioBuffers, nioBufferCount);
                    }
                }
            }
            i = i + 1 & mask;
        }
        this.nioBufferCount = nioBufferCount;
        this.nioBufferSize = nioBufferSize;
        return nioBuffers;
    }

    private static int fillBufferArray(ByteBuffer[] nioBufs, ByteBuffer[] nioBuffers, int nioBufferCount) {
        for (ByteBuffer nioBuf : nioBufs) {
            if (nioBuf == null) break;
            nioBuffers[nioBufferCount++] = nioBuf;
        }
        return nioBufferCount;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] array, int neededSpace, int size) {
        int newCapacity = array.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        ByteBuffer[] newArray = new ByteBuffer[newCapacity];
        System.arraycopy(array, 0, newArray, 0, size);
        return newArray;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    @Override
    public void recycle() {
        if (this.nioBuffers.length > 32) {
            this.nioBuffers = new ByteBuffer[32];
        } else {
            Arrays.fill(this.nioBuffers, null);
        }
        super.recycle();
    }

    @Override
    protected NioEntry newEntry() {
        return new NioEntry();
    }

    protected static final class NioEntry
    extends ChannelOutboundBuffer.Entry {
        ByteBuffer[] buffers;
        ByteBuffer buf;
        int count = -1;

        protected NioEntry() {
        }

        @Override
        public void clear() {
            this.buffers = null;
            this.buf = null;
            this.count = -1;
            super.clear();
        }

        @Override
        public int cancel() {
            this.buffers = null;
            this.buf = null;
            this.count = -1;
            return super.cancel();
        }
    }
}

