/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoderBuffer;
import io.netty.util.Signal;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = new Signal(ReplayingDecoder.class.getName() + ".REPLAY");
    private ByteBuf cumulation;
    private ReplayingDecoderBuffer replayable;
    private S state;
    private int checkpoint = -1;
    private boolean decodeWasNull;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(S initialState) {
        this.state = initialState;
    }

    protected void checkpoint() {
        this.checkpoint = this.cumulation.readerIndex();
    }

    protected void checkpoint(S state) {
        this.checkpoint();
        this.state(state);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S newState) {
        S oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        return this.cumulation;
    }

    @Override
    public final ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.cumulation = this.newInboundBuffer0(ctx);
        this.replayable = new ReplayingDecoderBuffer(this.cumulation);
        return this.cumulation;
    }

    protected ByteBuf newInboundBuffer0(ChannelHandlerContext ctx) throws Exception {
        return super.newInboundBuffer(ctx);
    }

    @Override
    public final void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        int oldReaderIndex = in.readerIndex();
        this.discardInboundReadBytes0(ctx);
        int newReaderIndex = in.readerIndex();
        this.checkpoint -= oldReaderIndex - newReaderIndex;
    }

    protected void discardInboundReadBytes0(ChannelHandlerContext ctx) throws Exception {
        super.discardInboundReadBytes(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.replayable.terminate();
            ByteBuf in = this.cumulation;
            if (in.isReadable()) {
                this.callDecode(ctx, in);
            }
            if (ctx.nextInboundMessageBuffer().unfoldAndAdd(this.decodeLast(ctx, this.replayable))) {
                ctx.fireInboundBufferUpdated();
            }
        }
        catch (Signal replay) {
            replay.expect(REPLAY);
        }
        catch (Throwable t) {
            if (t instanceof CodecException) {
                ctx.fireExceptionCaught(t);
            } else {
                ctx.fireExceptionCaught(new DecoderException(t));
            }
        }
        finally {
            ctx.fireChannelInactive();
        }
    }

    @Override
    protected void callDecode(ChannelHandlerContext ctx, ByteBuf buf) {
        boolean wasNull = false;
        ByteBuf in = this.cumulation;
        MessageBuf<Object> out = ctx.nextInboundMessageBuffer();
        boolean decoded = false;
        while (in.isReadable()) {
            try {
                S oldState;
                Object result;
                int oldReaderIndex;
                block13: {
                    oldReaderIndex = this.checkpoint = in.readerIndex();
                    result = null;
                    oldState = this.state;
                    try {
                        result = this.decode(ctx, this.replayable);
                        if (result == null) {
                            if (oldReaderIndex != in.readerIndex() || oldState != this.state) continue;
                            throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                        }
                    }
                    catch (Signal replay) {
                        replay.expect(REPLAY);
                        int checkpoint = this.checkpoint;
                        if (checkpoint < 0) break block13;
                        in.readerIndex(checkpoint);
                    }
                }
                if (result == null) {
                    wasNull = true;
                    break;
                }
                wasNull = false;
                if (oldReaderIndex == in.readerIndex() && oldState == this.state) {
                    throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ')');
                }
                if (!out.unfoldAndAdd(result)) continue;
                decoded = true;
                if (!this.isSingleDecode()) continue;
                break;
            }
            catch (Throwable t) {
                if (decoded) {
                    decoded = false;
                    ctx.fireInboundBufferUpdated();
                }
                if (t instanceof CodecException) {
                    ctx.fireExceptionCaught(t);
                    break;
                }
                ctx.fireExceptionCaught(new DecoderException(t));
                break;
            }
        }
        if (decoded) {
            this.decodeWasNull = false;
            ctx.fireInboundBufferUpdated();
        } else if (wasNull) {
            this.decodeWasNull = true;
        }
    }

    @Override
    public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        super.channelReadSuspended(ctx);
    }
}

