/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.BufUtil;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelStateHandlerAdapter;
import io.netty.util.Signal;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class ChannelInboundMessageHandlerAdapter<I>
extends ChannelStateHandlerAdapter
implements ChannelInboundMessageHandler<I> {
    protected static final Signal ABORT = new Signal(ChannelInboundMessageHandlerAdapter.class.getName() + ".ABORT");
    private final TypeParameterMatcher msgMatcher = TypeParameterMatcher.find(this, ChannelInboundMessageHandlerAdapter.class, "I");

    protected ChannelInboundMessageHandlerAdapter() {
    }

    @Override
    public MessageBuf<I> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        ctx.inboundMessageBuffer().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        MessageBuf in = ctx.inboundMessageBuffer();
        if (in.isEmpty() || !this.beginMessageReceived(ctx)) {
            return;
        }
        MessageBuf<Object> out = ctx.nextInboundMessageBuffer();
        int oldOutSize = out.size();
        try {
            Object msg;
            boolean unsupportedFound = false;
            while ((msg = in.poll()) != null) {
                if (!this.acceptInboundMessage(msg)) {
                    out.add(msg);
                    unsupportedFound = true;
                    continue;
                }
                if (unsupportedFound) {
                    unsupportedFound = false;
                    ctx.fireInboundBufferUpdated();
                    oldOutSize = out.size();
                }
                Object imsg = msg;
                try {
                    this.messageReceived(ctx, imsg);
                    continue;
                }
                catch (Signal abort) {
                    abort.expect(ABORT);
                }
                finally {
                    BufUtil.release(imsg);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.exceptionCaught(ctx, t);
        }
        finally {
            if (oldOutSize != out.size()) {
                ctx.fireInboundBufferUpdated();
            }
            this.endMessageReceived(ctx);
        }
    }

    protected boolean acceptInboundMessage(Object msg) throws Exception {
        return this.msgMatcher.match(msg);
    }

    protected boolean beginMessageReceived(ChannelHandlerContext ctx) throws Exception {
        return true;
    }

    protected abstract void messageReceived(ChannelHandlerContext var1, I var2) throws Exception;

    protected void endMessageReceived(ChannelHandlerContext ctx) throws Exception {
    }
}

