/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

class ByteArrayArgument
implements Argument {
    private final byte[] value;

    ByteArrayArgument(byte[] value) {
        this.value = value;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value != null) {
            statement.setBytes(position, this.value);
        } else {
            statement.setNull(position, -3);
        }
    }

    public String toString() {
        return Arrays.toString(this.value);
    }
}

