/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.buffer;

import org.apache.hive.druid.org.roaringbitmap.ShortIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.BufferUtil;
import org.apache.hive.druid.org.roaringbitmap.buffer.MappeableRunContainer;

final class ReverseMappeableRunContainerShortIterator
implements ShortIterator {
    int pos;
    int le;
    int maxlength;
    int base;
    MappeableRunContainer parent;

    ReverseMappeableRunContainerShortIterator() {
    }

    ReverseMappeableRunContainerShortIterator(MappeableRunContainer p) {
        this.wrap(p);
    }

    void wrap(MappeableRunContainer p) {
        this.parent = p;
        this.pos = this.parent.nbrruns - 1;
        this.le = 0;
        if (this.pos >= 0) {
            this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
            this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public short next() {
        short ans = (short)(this.base + this.maxlength - this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.maxlength - this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

