/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.roaringbitmap.buffer;

import org.apache.hive.druid.org.roaringbitmap.ShortIterator;
import org.apache.hive.druid.org.roaringbitmap.buffer.MappeableBitmapContainer;

final class MappeableBitmapContainerShortIterator
implements ShortIterator {
    long w;
    int x;
    static final int len = 1024;
    MappeableBitmapContainer parent;

    MappeableBitmapContainerShortIterator() {
    }

    MappeableBitmapContainerShortIterator(MappeableBitmapContainer p) {
        this.wrap(p);
    }

    void wrap(MappeableBitmapContainer p) {
        this.parent = p;
        this.x = 0;
        while (this.x < 1024 && (this.w = this.parent.bitmap.get(this.x)) == 0L) {
            ++this.x;
        }
    }

    @Override
    public boolean hasNext() {
        return this.x < 1024;
    }

    @Override
    public short next() {
        long t = this.w & -this.w;
        short answer = (short)(this.x * 64 + Long.bitCount(t - 1L));
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == 1024) break;
            this.w = this.parent.bitmap.get(this.x);
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        long t = this.w & -this.w;
        int answer = this.x * 64 + Long.bitCount(t - 1L);
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == 1024) break;
            this.w = this.parent.bitmap.get(this.x);
        }
        return answer;
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }
}

