/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx;

import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.channel.Channel;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.hive.druid.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.apache.hive.druid.org.jboss.netty.handler.codec.replay.VoidEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocket00FrameDecoder
extends ReplayingDecoder<VoidEnum> {
    private static final long DEFAULT_MAX_FRAME_SIZE = 16384L;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384L);
    }

    public WebSocket00FrameDecoder(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        if (this.receivedClosingHandshake) {
            buffer.skipBytes(this.actualReadableBytes());
            return null;
        }
        byte type = buffer.readByte();
        if ((type & 0x80) == 128) {
            return this.decodeBinaryFrame(type, buffer);
        }
        return this.decodeTextFrame(buffer);
    }

    private WebSocketFrame decodeBinaryFrame(byte type, ChannelBuffer buffer) throws TooLongFrameException {
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer.readByte();
            frameSize <<= 7;
            if ((frameSize |= (long)(b & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (type == -1 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame();
        }
        return new BinaryWebSocketFrame(buffer.readBytes((int)frameSize));
    }

    private WebSocketFrame decodeTextFrame(ChannelBuffer buffer) throws TooLongFrameException {
        int rbytes;
        int ridx = buffer.readerIndex();
        int delimPos = buffer.indexOf(ridx, ridx + (rbytes = this.actualReadableBytes()), (byte)-1);
        if (delimPos == -1) {
            if ((long)rbytes > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int frameSize = delimPos - ridx;
        if ((long)frameSize > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ChannelBuffer binaryData = buffer.readBytes(frameSize);
        buffer.skipBytes(1);
        int ffDelimPos = binaryData.indexOf(binaryData.readerIndex(), binaryData.writerIndex(), (byte)-1);
        if (ffDelimPos >= 0) {
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame(binaryData);
    }
}

