/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.hive.druid.org.jboss.netty.channel.Channel;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelException;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelFactory;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelPipeline;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelSink;
import org.apache.hive.druid.org.jboss.netty.channel.socket.DefaultSocketChannelConfig;
import org.apache.hive.druid.org.jboss.netty.channel.socket.SocketChannel;
import org.apache.hive.druid.org.jboss.netty.channel.socket.SocketChannelConfig;
import org.apache.hive.druid.org.jboss.netty.channel.socket.oio.AbstractOioChannel;

abstract class OioSocketChannel
extends AbstractOioChannel
implements SocketChannel {
    final Socket socket;
    private final SocketChannelConfig config;

    OioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        try {
            socket.setSoTimeout(1000);
        }
        catch (SocketException e) {
            throw new ChannelException("Failed to configure the OioSocketChannel socket timeout.", e);
        }
        this.config = new DefaultSocketChannelConfig(socket);
    }

    public SocketChannelConfig getConfig() {
        return this.config;
    }

    abstract PushbackInputStream getInputStream();

    abstract OutputStream getOutputStream();

    boolean isSocketBound() {
        return this.socket.isBound();
    }

    boolean isSocketConnected() {
        return this.socket.isConnected();
    }

    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    void closeSocket() throws IOException {
        this.socket.close();
    }

    boolean isSocketClosed() {
        return this.socket.isClosed();
    }
}

