/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.nio;

import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ThreadFactory;
import org.apache.hive.druid.io.netty.channel.DefaultSelectStrategyFactory;
import org.apache.hive.druid.io.netty.channel.MultithreadEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.SelectStrategyFactory;
import org.apache.hive.druid.io.netty.channel.nio.NioEventLoop;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.RejectedExecutionHandler;
import org.apache.hive.druid.io.netty.util.concurrent.RejectedExecutionHandlers;

public class NioEventLoopGroup
extends MultithreadEventLoopGroup {
    public NioEventLoopGroup() {
        this(0);
    }

    public NioEventLoopGroup(int nThreads) {
        this(nThreads, null);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider) {
        this(nThreads, threadFactory, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, threadFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(nThreads, threadFactory, selectorProvider, selectStrategyFactory, rejectedExecutionHandler);
    }

    public void setIoRatio(int ioRatio) {
        for (EventExecutor e : this.children()) {
            ((NioEventLoop)e).setIoRatio(ioRatio);
        }
    }

    public void rebuildSelectors() {
        for (EventExecutor e : this.children()) {
            ((NioEventLoop)e).rebuildSelector();
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, Object ... args) throws Exception {
        return new NioEventLoop(this, threadFactory, (SelectorProvider)args[0], ((SelectStrategyFactory)args[1]).newSelectStrategy(), (RejectedExecutionHandler)args[2]);
    }
}

