/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.timeline.partition;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpecLookup;

public class NumberedShardSpec
implements ShardSpec {
    @JsonIgnore
    private final int partitionNum;
    @JsonIgnore
    private final int partitions;

    @JsonCreator
    public NumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions) {
        Preconditions.checkArgument(partitionNum >= 0, "partitionNum >= 0");
        Preconditions.checkArgument(partitions >= 0, "partitions >= 0");
        this.partitionNum = partitionNum;
        this.partitions = partitions;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            @Override
            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                return (ShardSpec)shardSpecs.get(0);
            }
        };
    }

    @Override
    public Map<String, Range<String>> getDomain() {
        return ImmutableMap.of();
    }

    @JsonProperty(value="partitions")
    public int getPartitions() {
        return this.partitions;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return NumberedPartitionChunk.make(this.partitionNum, this.partitions, obj);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return true;
    }

    public String toString() {
        return "NumberedShardSpec{partitionNum=" + this.partitionNum + ", partitions=" + this.partitions + '}';
    }
}

