/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentFinder;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class HdfsDataSegmentFinder
implements DataSegmentFinder {
    private static final Logger log = new Logger(HdfsDataSegmentFinder.class);
    private final Configuration config;
    private final ObjectMapper mapper;

    @Inject
    public HdfsDataSegmentFinder(Configuration config, ObjectMapper mapper) {
        this.config = config;
        this.mapper = mapper;
    }

    @Override
    public Set<DataSegment> findSegments(String workingDirPathStr, boolean updateDescriptor) throws SegmentLoadingException {
        HashSet<DataSegment> segments = Sets.newHashSet();
        Path workingDirPath = new Path(workingDirPathStr);
        try {
            FileSystem fs = workingDirPath.getFileSystem(this.config);
            log.info(fs.getScheme(), new Object[0]);
            log.info("FileSystem URI:" + fs.getUri().toString(), new Object[0]);
            if (!fs.exists(workingDirPath)) {
                throw new SegmentLoadingException("Working directory [%s] doesn't exist.", workingDirPath);
            }
            if (!fs.isDirectory(workingDirPath)) {
                throw new SegmentLoadingException("Working directory [%s] is not a directory!?", workingDirPath);
            }
            RemoteIterator it = fs.listFiles(workingDirPath, true);
            while (it.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)it.next();
                Path path = locatedFileStatus.getPath();
                if (!path.getName().endsWith("descriptor.json")) continue;
                String[] descriptorParts = path.getName().split("_");
                Path indexZip = descriptorParts.length == 2 && descriptorParts[1].equals("descriptor.json") && StringUtils.isNumeric((String)descriptorParts[0]) ? new Path(path.getParent(), org.apache.hive.druid.io.druid.java.util.common.StringUtils.format("%s_index.zip", descriptorParts[0])) : new Path(path.getParent(), "index.zip");
                if (fs.exists(indexZip)) {
                    DataSegment dataSegment = this.mapper.readValue((InputStream)fs.open(path), DataSegment.class);
                    log.info("Found segment [%s] located at [%s]", dataSegment.getIdentifier(), indexZip);
                    Map<String, Object> loadSpec = dataSegment.getLoadSpec();
                    String pathWithoutScheme = indexZip.toUri().getPath();
                    if (!loadSpec.get("type").equals("hdfs") || !loadSpec.get("path").equals(pathWithoutScheme)) {
                        loadSpec.put("type", "hdfs");
                        loadSpec.put("path", pathWithoutScheme);
                        if (updateDescriptor) {
                            log.info("Updating loadSpec in descriptor.json at [%s] with new path [%s]", path, pathWithoutScheme);
                            this.mapper.writeValue((OutputStream)fs.create(path, true), (Object)dataSegment);
                        }
                    }
                    segments.add(dataSegment);
                    continue;
                }
                throw new SegmentLoadingException("index.zip didn't exist at [%s] while descripter.json exists!?", indexZip);
            }
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "Problems interacting with filesystem[%s].", workingDirPath);
        }
        return segments;
    }
}

