/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.io.druid.client.DruidServerConfig;
import org.apache.hive.druid.io.druid.server.SegmentManager;
import org.apache.hive.druid.io.druid.server.coordination.ZkCoordinator;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class HistoricalMetricsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final SegmentManager segmentManager;
    private final ZkCoordinator zkCoordinator;

    @Inject
    public HistoricalMetricsMonitor(DruidServerConfig serverConfig, SegmentManager segmentManager, ZkCoordinator zkCoordinator) {
        this.serverConfig = serverConfig;
        this.segmentManager = segmentManager;
        this.zkCoordinator = zkCoordinator;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/max", this.serverConfig.getMaxSize()));
        Object2LongOpenHashMap<String> pendingDeleteSizes = new Object2LongOpenHashMap<String>();
        for (DataSegment dataSegment : this.zkCoordinator.getPendingDeleteSnapshot()) {
            pendingDeleteSizes.addTo(dataSegment.getDataSource(), dataSegment.getSize());
        }
        for (Object2LongMap.Entry entry : pendingDeleteSizes.object2LongEntrySet()) {
            dataSource = (String)entry.getKey();
            long pendingDeleteSize = entry.getLongValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority())).build("segment/pendingDelete", pendingDeleteSize));
        }
        for (Map.Entry entry : this.segmentManager.getDataSourceSizes().entrySet()) {
            dataSource = (String)entry.getKey();
            long used = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/used", used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("segment/usedPercent", usedPercent));
        }
        for (Map.Entry entry : this.segmentManager.getDataSourceCounts().entrySet()) {
            dataSource = (String)entry.getKey();
            long count = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/count", count));
        }
        return true;
    }
}

