/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.metrics.EventReceiverFirehoseMetric;

public class EventReceiverFirehoseRegister {
    private static final Logger log = new Logger(EventReceiverFirehoseRegister.class);
    private final ConcurrentMap<String, EventReceiverFirehoseMetric> metrics = new ConcurrentHashMap<String, EventReceiverFirehoseMetric>();

    public void register(String serviceName, EventReceiverFirehoseMetric metric) {
        log.info("Registering EventReceiverFirehoseMetric for service [%s]", serviceName);
        if (this.metrics.putIfAbsent(serviceName, metric) != null) {
            throw new ISE("Service [%s] is already registered!", serviceName);
        }
    }

    public Iterable<Map.Entry<String, EventReceiverFirehoseMetric>> getMetrics() {
        return this.metrics.entrySet();
    }

    public void unregister(String serviceName) {
        log.info("Unregistering EventReceiverFirehoseMetric for service [%s]", serviceName);
        if (this.metrics.remove(serviceName) == null) {
            log.warn("Unregistering a non-exist service. Service [%s] never exists.", new Object[0]);
        }
    }
}

