/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="filtered")
public class FilteredRequestLoggerProvider
implements RequestLoggerProvider {
    @JsonProperty
    @NotNull
    private RequestLoggerProvider delegate = null;
    @JsonProperty
    private long queryTimeThresholdMs = 0L;

    public RequestLogger get() {
        return new FilteredRequestLogger((RequestLogger)this.delegate.get(), this.queryTimeThresholdMs);
    }

    public static class FilteredRequestLogger
    implements RequestLogger {
        private final long queryTimeThresholdMs;
        private final RequestLogger logger;

        public FilteredRequestLogger(RequestLogger logger, long queryTimeThresholdMs) {
            this.logger = logger;
            this.queryTimeThresholdMs = queryTimeThresholdMs;
        }

        @Override
        public void log(RequestLogLine requestLogLine) throws IOException {
            Object queryTime = requestLogLine.getQueryStats().getStats().get("query/time");
            if (queryTime != null && ((Number)queryTime).longValue() >= this.queryTimeThresholdMs) {
                this.logger.log(requestLogLine);
            }
        }
    }
}

