/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization.jetty;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.Properties;
import org.apache.hive.druid.io.druid.guice.Jerseys;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.annotations.RemoteChatHandler;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandlerResource;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyBindings;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerModule;
import org.apache.hive.druid.io.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.hive.druid.io.druid.server.initialization.jetty.TaskIdResponseHeaderFilterHolder;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;
import org.eclipse.jetty.server.Server;

public class ChatHandlerServerModule
implements Module {
    private static final Logger log = new Logger(ChatHandlerServerModule.class);
    private static final String MAX_CHAT_REQUESTS_PROPERTY = "druid.indexer.server.maxChatRequests";
    private static final String CHAT_PORT_PROPERTY = "druid.indexer.task.chathandler.port";
    private final Properties properties;

    public ChatHandlerServerModule(Properties properties) {
        this.properties = properties;
    }

    public void configure(Binder binder) {
        Jerseys.addResource(binder, ChatHandlerResource.class);
        LifecycleModule.register(binder, ChatHandlerResource.class);
        if (this.properties.containsKey(MAX_CHAT_REQUESTS_PROPERTY)) {
            int maxRequests = Integer.parseInt(this.properties.getProperty(MAX_CHAT_REQUESTS_PROPERTY));
            JettyBindings.addQosFilter(binder, "/druid/worker/v1/chat/*", maxRequests);
        }
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class).addBinding().to(TaskIdResponseHeaderFilterHolder.class);
        if (this.properties.containsKey(CHAT_PORT_PROPERTY)) {
            log.info("Spawning separate ingestion server at port [%s]", this.properties.getProperty(CHAT_PORT_PROPERTY));
            JsonConfigProvider.bind(binder, "druid.indexer.task.chathandler", DruidNode.class, RemoteChatHandler.class);
            JsonConfigProvider.bind(binder, "druid.indexer.server.chathandler.http", ServerConfig.class, RemoteChatHandler.class);
            LifecycleModule.register(binder, Server.class, RemoteChatHandler.class);
        } else {
            binder.bind(DruidNode.class).annotatedWith(RemoteChatHandler.class).to(Key.get(DruidNode.class, Self.class));
            binder.bind(ServerConfig.class).annotatedWith(RemoteChatHandler.class).to(Key.get(ServerConfig.class));
        }
    }

    @Provides
    @LazySingleton
    public TaskIdResponseHeaderFilterHolder taskIdResponseHeaderFilterHolderBuilder(DataSourceTaskIdHolder taskIdHolder) {
        return new TaskIdResponseHeaderFilterHolder("/druid/worker/v1/chat/*", taskIdHolder.getTaskId());
    }

    @Provides
    @LazySingleton
    @RemoteChatHandler
    public Server getServer(Injector injector, Lifecycle lifecycle, @RemoteChatHandler DruidNode node, @RemoteChatHandler ServerConfig config) {
        Server server = JettyServerModule.makeJettyServer(node, config);
        JettyServerModule.initializeServer(injector, lifecycle, server);
        return server;
    }
}

