/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Period;

public class ServerConfig {
    @JsonProperty
    @Min(value=1L)
    private int numThreads = Math.max(10, Runtime.getRuntime().availableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @NotNull
    private Period maxIdleTime = new Period((Object)"PT5m");
    @JsonProperty
    @Min(value=0L)
    private long defaultQueryTimeout = 300000L;
    @JsonProperty
    @Min(value=1L)
    private long maxScatterGatherBytes = Long.MAX_VALUE;

    public int getNumThreads() {
        return this.numThreads;
    }

    public Period getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public long getMaxScatterGatherBytes() {
        return this.maxScatterGatherBytes;
    }

    public String toString() {
        return "ServerConfig{numThreads=" + this.numThreads + ", maxIdleTime=" + this.maxIdleTime + ", defaultQueryTimeout=" + this.defaultQueryTimeout + ", maxScatterGatherBytes=" + this.maxScatterGatherBytes + '}';
    }
}

