/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;

public class ConfigResourceFilter
extends AbstractResourceFilter {
    @Inject
    public ConfigResourceFilter(AuthConfig authConfig) {
        super(authConfig);
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.getAuthConfig().isEnabled()) {
            String resourceName = "CONFIG";
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)this.getReq().getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull(authorizationInfo, "Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource("CONFIG", ResourceType.CONFIG), this.getAction(request));
            if (!authResult.isAllowed()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringUtils.format("Access-Check-Result: %s", authResult.toString())).build());
            }
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        return requestPath.startsWith("druid/worker/v1") || requestPath.startsWith("druid/indexer/v1") || requestPath.startsWith("druid/coordinator/v1/config");
    }
}

