/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.server.coordination.BatchDataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestHistory;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestsSnapshot;
import org.apache.hive.druid.io.druid.server.http.security.StateResourceFilter;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;

@Path(value="/druid-internal/v1/segments/")
@ResourceFilters(value={StateResourceFilter.class})
public class SegmentListerResource {
    protected static final EmittingLogger log = new EmittingLogger(SegmentListerResource.class);
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final AuthConfig authConfig;
    private final BatchDataSegmentAnnouncer announcer;

    @Inject
    public SegmentListerResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, AuthConfig authConfig, @Nullable BatchDataSegmentAnnouncer announcer) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.authConfig = authConfig;
        this.announcer = announcer;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public void getSegments(@QueryParam(value="counter") long counter, @QueryParam(value="hash") long hash, @QueryParam(value="timeout") long timeout, @Context HttpServletRequest req) throws IOException {
        if (this.announcer == null) {
            this.sendErrorResponse(req, 404, "announcer is not available.");
            return;
        }
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<SegmentChangeRequestsSnapshot> future = this.announcer.getSegmentChangesSince(new SegmentChangeRequestHistory.Counter(counter, hash));
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
        Futures.addCallback(future, new FutureCallback<SegmentChangeRequestsSnapshot>(){

            @Override
            public void onSuccess(SegmentChangeRequestsSnapshot result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), (Object)result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            @Override
            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug(ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
    }

    private void sendErrorResponse(HttpServletRequest req, int code, String error) throws IOException {
        AsyncContext asyncContext = req.startAsync();
        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        response.sendError(code, error);
        asyncContext.complete();
    }

    private ResponseContext createContext(String requestType) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType);
        return new ResponseContext(isSmile ? this.smileMapper : this.jsonMapper);
    }

    private static class ResponseContext {
        private final ObjectMapper inputMapper;

        ResponseContext(ObjectMapper inputMapper) {
            this.inputMapper = inputMapper;
        }
    }
}

