/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.http.security.StateResourceFilter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

@Path(value="/druid/coordinator/v1")
@ResourceFilters(value={StateResourceFilter.class})
public class CoordinatorResource {
    private final DruidCoordinator coordinator;

    @Inject
    public CoordinatorResource(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @GET
    @Path(value="/leader")
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.coordinator.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/isLeader")
    @Produces(value={"application/json"})
    public Response isLeader() {
        boolean leading = this.coordinator.isLeader();
        ImmutableMap<String, Boolean> response = ImmutableMap.of("leader", leading);
        if (leading) {
            return Response.ok(response).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(response).build();
    }

    @GET
    @Path(value="/loadstatus")
    @Produces(value={"application/json"})
    public Response getLoadStatus(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple != null) {
            return Response.ok(this.coordinator.getSegmentAvailability()).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getReplicationStatus()).build();
        }
        return Response.ok(this.coordinator.getLoadStatus()).build();
    }

    @GET
    @Path(value="/loadqueue")
    @Produces(value={"application/json"})
    public Response getLoadQueue(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple != null) {
            return Response.ok(Maps.transformValues(this.coordinator.getLoadManagementPeons(), new Function<LoadQueuePeon, Object>(){

                @Override
                public Object apply(LoadQueuePeon input) {
                    long loadSize = 0L;
                    for (DataSegment dataSegment : input.getSegmentsToLoad()) {
                        loadSize += dataSegment.getSize();
                    }
                    long dropSize = 0L;
                    for (DataSegment dataSegment : input.getSegmentsToDrop()) {
                        dropSize += dataSegment.getSize();
                    }
                    return new ImmutableMap.Builder<String, Integer>().put("segmentsToLoad", input.getSegmentsToLoad().size()).put("segmentsToDrop", input.getSegmentsToDrop().size()).put("segmentsToLoadSize", (Integer)loadSize).put("segmentsToDropSize", (Integer)dropSize).build();
                }
            })).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getLoadManagementPeons()).build();
        }
        return Response.ok(Maps.transformValues(this.coordinator.getLoadManagementPeons(), new Function<LoadQueuePeon, Object>(){

            @Override
            public Object apply(LoadQueuePeon input) {
                return new ImmutableMap.Builder<String, Collection<Object>>().put("segmentsToLoad", Collections2.transform(input.getSegmentsToLoad(), new Function<DataSegment, Object>(){

                    @Override
                    public String apply(DataSegment segment) {
                        return segment.getIdentifier();
                    }
                })).put("segmentsToDrop", Collections2.transform(input.getSegmentsToDrop(), new Function<DataSegment, Object>(){

                    @Override
                    public String apply(DataSegment segment) {
                        return segment.getIdentifier();
                    }
                })).build();
            }
        })).build();
    }
}

