/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.HashMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;

public class DruidCoordinatorCleanupOvershadowed
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanupOvershadowed(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        if (params.hasDeletionWaitTimeElapsed()) {
            DruidCluster cluster = params.getDruidCluster();
            HashMap timelines = Maps.newHashMap();
            for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedHistoricalsByTier()) {
                for (ServerHolder serverHolder : serverHolders) {
                    ImmutableDruidServer server = serverHolder.getServer();
                    for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
                        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSource.getName());
                        if (timeline == null) {
                            timeline = new VersionedIntervalTimeline(Comparators.comparable());
                            timelines.put(dataSource.getName(), timeline);
                        }
                        for (DataSegment segment : dataSource.getSegments()) {
                            timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
                        }
                    }
                }
            }
            for (DataSegment dataSegment : params.getAvailableSegments()) {
                VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
                if (timeline == null || !timeline.isOvershadowed(dataSegment.getInterval(), dataSegment.getVersion())) continue;
                this.coordinator.removeSegment(dataSegment);
                stats.addToGlobalStat("overShadowedCount", 1L);
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

