/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.CachingQueryRunner;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.guice.annotations.BackgroundCaching;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.query.BySegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.CPUTimeMetricQueryRunner;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.MetricsEmittingQueryRunner;
import org.apache.hive.druid.io.druid.query.NoopQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.io.druid.server.SegmentManager;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final ExecutorService cachingExec;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, @BackgroundCaching ExecutorService cachingExec, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachingExec = cachingExec;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", query.getClass());
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = query.getDataSource();
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat(new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            @Override
            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create(holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    @Override
                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), toolChest, this.emitter, cpuTimeAccumulator, true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return Iterables.getOnlyElement(dataSource.getNames());
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", query.getClass()).addData("dataSource", query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.segmentManager.getTimeline(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), input.getVersion());
                if (entry == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Collections.singletonList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Collections.singletonList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), toolChest, this.emitter, cpuTimeAccumulator, true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        String segmentId = adapter.getIdentifier();
        return CPUTimeMetricQueryRunner.safeBuild(new SpecificSegmentQueryRunner<T>(new MetricsEmittingQueryRunner<T>(this.emitter, toolChest, new BySegmentQueryRunner<T>(segmentId, adapter.getDataInterval().getStart(), new CachingQueryRunner<T>(segmentId, segmentDescriptor, this.objectMapper, this.cache, toolChest, new MetricsEmittingQueryRunner<T>(this.emitter, toolChest, new ReferenceCountingSegmentQueryRunner<T>(factory, adapter, segmentDescriptor), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentId)), this.cachingExec, this.cacheConfig)), QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentId)).withWaitMeasuredFromNow(), segmentSpec), toolChest, this.emitter, cpuTimeAccumulator, false);
    }
}

