/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.client.DirectDruidClient;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielders;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.server.QueryLifecycle;
import org.apache.hive.druid.io.druid.server.QueryLifecycleFactory;
import org.apache.hive.druid.io.druid.server.QueryManager;
import org.apache.hive.druid.io.druid.server.metrics.QueryCountStatsProvider;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;
import org.joda.time.DateTime;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    protected static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final ObjectMapper serializeDateTimeAsLongJsonMapper;
    protected final ObjectMapper serializeDateTimeAsLongSmileMapper;
    protected final QueryManager queryManager;
    protected final AuthConfig authConfig;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryManager queryManager, AuthConfig authConfig) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = this.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = this.serializeDataTimeAsLong(smileMapper);
        this.queryManager = queryManager;
        this.authConfig = authConfig;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", queryId);
        }
        if (this.authConfig.isEnabled()) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull(authorizationInfo, "Security is enabled but no authorization info found in the request");
            Set<String> datasources = this.queryManager.getQueryDatasources(queryId);
            if (datasources == null) {
                log.warn("QueryId [%s] not registered with QueryManager, cannot cancel", queryId);
            } else {
                for (String dataSource : datasources) {
                    Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
                    if (authResult.isAllowed()) continue;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                }
            }
        }
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, final @Context HttpServletRequest req) throws IOException {
        final QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        Query query = null;
        ResponseContext context = this.createContext(req.getContentType(), pretty != null);
        final String currThreadName = Thread.currentThread().getName();
        try {
            Access authResult;
            queryLifecycle.initialize(QueryResource.readQuery(req, in, context));
            query = queryLifecycle.getQuery();
            String queryId = query.getId();
            Thread.currentThread().setName(StringUtils.format("%s[%s_%s_%s]", currThreadName, query.getType(), query.getDataSource().getNames(), queryId));
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", query);
            }
            if (!(authResult = queryLifecycle.authorize((AuthorizationInfo)req.getAttribute("Druid-Auth-Token"))).isAllowed()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                return response;
            }
            QueryLifecycle.QueryResponse queryResponse = queryLifecycle.execute();
            Sequence results = queryResponse.getResults();
            Map<String, Object> responseContext = queryResponse.getResponseContext();
            String prevEtag = QueryResource.getPreviousEtag(req);
            if (prevEtag != null && prevEtag.equals(responseContext.get(HEADER_ETAG))) {
                Response response = Response.notModified().build();
                return response;
            }
            final Yielder yielder = Yielders.each(results);
            try {
                boolean shouldFinalize = QueryContexts.isFinalize(query, true);
                boolean serializeDateTimeAsLong = QueryContexts.isSerializeDateTimeAsLong(query, false) || !shouldFinalize && QueryContexts.isSerializeDateTimeAsLongInner(query, false);
                final ObjectWriter jsonWriter = context.newOutputWriter(serializeDateTimeAsLong);
                Response.ResponseBuilder builder = Response.ok((Object)new StreamingOutput(){

                    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                        Exception e = null;
                        CountingOutputStream os = new CountingOutputStream(outputStream);
                        try {
                            jsonWriter.writeValue(os, (Object)yielder);
                            os.flush();
                            os.close();
                        }
                        catch (Exception ex) {
                            e = ex;
                            log.error(ex, "Unable to send query response.", new Object[0]);
                            throw Throwables.propagate(ex);
                        }
                        finally {
                            Thread.currentThread().setName(currThreadName);
                            queryLifecycle.emitLogsAndMetrics(e, req.getRemoteAddr(), os.getCount());
                            if (e == null) {
                                QueryResource.this.successfulQueryCount.incrementAndGet();
                            } else {
                                QueryResource.this.failedQueryCount.incrementAndGet();
                            }
                        }
                    }
                }, (String)context.getContentType()).header("X-Druid-Query-Id", (Object)queryId);
                if (responseContext.get(HEADER_ETAG) != null) {
                    builder.header(HEADER_ETAG, responseContext.get(HEADER_ETAG));
                    responseContext.remove(HEADER_ETAG);
                }
                DirectDruidClient.removeMagicResponseContextFields(responseContext);
                String responseCtxString = this.jsonMapper.writeValueAsString(responseContext);
                if (responseCtxString.length() > 7168) {
                    log.warn("Response Context truncated for id [%s] . Full context is [%s].", queryId, responseCtxString);
                    responseCtxString = responseCtxString.substring(0, 7168);
                }
                Response response = builder.header("X-Druid-Response-Context", (Object)responseCtxString).build();
                return response;
            }
            catch (Exception e) {
                Response response;
                try {
                    yielder.close();
                    throw Throwables.propagate(e);
                }
                catch (QueryInterruptedException e2) {
                    this.interruptedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e2, req.getRemoteAddr(), -1L);
                    response = context.gotError(e2);
                    return response;
                }
                catch (Exception e3) {
                    this.failedQueryCount.incrementAndGet();
                    queryLifecycle.emitLogsAndMetrics(e3, req.getRemoteAddr(), -1L);
                    log.makeAlert(e3, "Exception handling request", new Object[0]).addData("exception", e3.toString()).addData("query", query != null ? query.toString() : "unparseable query").addData("peer", req.getRemoteAddr()).emit();
                    response = context.gotError(e3);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private static Query<?> readQuery(HttpServletRequest req, InputStream in, ResponseContext context) throws IOException {
        Query baseQuery = context.getObjectMapper().readValue(in, Query.class);
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag != null) {
            baseQuery = baseQuery.withOverriddenContext(ImmutableMap.of(HEADER_IF_NONE_MATCH, prevEtag));
        }
        return baseQuery;
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    protected ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule(new SimpleModule().addSerializer(DateTime.class, new DateTimeSerializer()));
    }

    protected ResponseContext createContext(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResponseContext(contentType, isSmile ? this.smileMapper : this.jsonMapper, isSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty);
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    protected static class ResponseContext {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResponseContext(String contentType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        public ObjectMapper getObjectMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter(boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            return this.isPretty ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(false).writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter(false).writeValueAsBytes(QueryInterruptedException.wrapIfNeeded(e))).build();
        }
    }
}

