/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.FilteredServerInventoryView;
import org.apache.hive.druid.io.druid.client.ServerViewUtil;
import org.apache.hive.druid.io.druid.client.TimelineServerView;
import org.apache.hive.druid.io.druid.client.selector.ServerSelector;
import org.apache.hive.druid.io.druid.common.utils.JodaUtils;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.io.druid.server.http.security.DatasourceResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineLookup;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionHolder;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

@Path(value="/druid/v2/datasources")
public class ClientInfoResource {
    private static final Logger log = new Logger(ClientInfoResource.class);
    private static final String KEY_DIMENSIONS = "dimensions";
    private static final String KEY_METRICS = "metrics";
    private FilteredServerInventoryView serverInventoryView;
    private TimelineServerView timelineServerView;
    private SegmentMetadataQueryConfig segmentMetadataQueryConfig;
    private final AuthConfig authConfig;

    @Inject
    public ClientInfoResource(FilteredServerInventoryView serverInventoryView, TimelineServerView timelineServerView, SegmentMetadataQueryConfig segmentMetadataQueryConfig, AuthConfig authConfig) {
        this.serverInventoryView = serverInventoryView;
        this.timelineServerView = timelineServerView;
        this.segmentMetadataQueryConfig = segmentMetadataQueryConfig == null ? new SegmentMetadataQueryConfig() : segmentMetadataQueryConfig;
        this.authConfig = authConfig;
    }

    private Map<String, List<DataSegment>> getSegmentsForDatasources() {
        HashMap<String, List<DataSegment>> dataSourceMap = Maps.newHashMap();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            for (DruidDataSource dataSource : server.getDataSources()) {
                if (!dataSourceMap.containsKey(dataSource.getName())) {
                    dataSourceMap.put(dataSource.getName(), Lists.newArrayList());
                }
                List segments = (List)dataSourceMap.get(dataSource.getName());
                segments.addAll(dataSource.getSegments());
            }
        }
        return dataSourceMap;
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<String> getDataSources(@Context HttpServletRequest request) {
        if (this.authConfig.isEnabled()) {
            final HashMap resourceAccessMap = new HashMap();
            final AuthorizationInfo authorizationInfo = (AuthorizationInfo)request.getAttribute("Druid-Auth-Token");
            return Collections2.filter(this.getSegmentsForDatasources().keySet(), new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    Resource resource = new Resource(input, ResourceType.DATASOURCE);
                    Action action = Action.READ;
                    Pair<Resource, Action> key = new Pair<Resource, Action>(resource, action);
                    if (resourceAccessMap.containsKey(key)) {
                        return ((Access)resourceAccessMap.get(key)).isAllowed();
                    }
                    Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)((Object)key.rhs));
                    resourceAccessMap.put(key, access);
                    return access.isAllowed();
                }
            });
        }
        return this.getSegmentsForDatasources().keySet();
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Map<String, Object> getDatasource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="full") String full) {
        void var9_11;
        List<TimelineObjectHolder<String, ServerSelector>> serversLookup;
        Interval theInterval;
        if (full == null) {
            return ImmutableMap.of(KEY_DIMENSIONS, this.getDatasourceDimensions(dataSourceName, interval), KEY_METRICS, this.getDatasourceMetrics(dataSourceName, interval));
        }
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = new Interval((Object)interval);
        }
        TimelineLookup<String, ServerSelector> timeline = this.timelineServerView.getTimeline(new TableDataSource(dataSourceName));
        List<TimelineObjectHolder<String, ServerSelector>> list = serversLookup = timeline != null ? timeline.lookup(theInterval) : null;
        if (serversLookup == null || Iterables.isEmpty(serversLookup)) {
            return Collections.EMPTY_MAP;
        }
        TreeMap servedIntervals = new TreeMap(new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                if (o1.equals((Object)o2) || o1.overlaps((ReadableInterval)o2)) {
                    return 0;
                }
                return o1.isBefore((ReadableInterval)o2) ? -1 : 1;
            }
        });
        for (TimelineObjectHolder timelineObjectHolder : serversLookup) {
            HashSet<String> dimensions = Sets.newHashSet();
            HashSet<String> metrics = Sets.newHashSet();
            PartitionHolder partitionHolder = timelineObjectHolder.getObject();
            if (partitionHolder.isComplete()) {
                for (ServerSelector server : partitionHolder.payloads()) {
                    DataSegment segment = server.getSegment();
                    dimensions.addAll(segment.getDimensions());
                    metrics.addAll(segment.getMetrics());
                }
            }
            servedIntervals.put(timelineObjectHolder.getInterval(), ImmutableMap.of(KEY_DIMENSIONS, dimensions, KEY_METRICS, metrics));
        }
        LinkedHashMap<String, Object> result = Maps.newLinkedHashMap();
        Object var9_10 = null;
        Map cols = null;
        for (Map.Entry e : servedIntervals.entrySet()) {
            Interval ival = (Interval)e.getKey();
            if (var9_11 != null && var9_11.abuts((ReadableInterval)ival) && cols.equals(e.getValue())) {
                Interval interval2 = var9_11.withEnd((ReadableInstant)ival.getEnd());
                continue;
            }
            if (var9_11 != null) {
                result.put(var9_11.toString(), cols);
            }
            Interval interval3 = ival;
            cols = (Map)e.getValue();
        }
        if (var9_11 != null) {
            result.put(var9_11.toString(), cols);
        }
        return result;
    }

    @GET
    @Path(value="/{dataSourceName}/dimensions")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<String> getDatasourceDimensions(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        List<DataSegment> segments = this.getSegmentsForDatasources().get(dataSourceName);
        HashSet<String> dims = Sets.newHashSet();
        if (segments == null || segments.isEmpty()) {
            return dims;
        }
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = new Interval((Object)interval);
        }
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            dims.addAll(segment.getDimensions());
        }
        return dims;
    }

    @GET
    @Path(value="/{dataSourceName}/metrics")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<String> getDatasourceMetrics(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        List<DataSegment> segments = this.getSegmentsForDatasources().get(dataSourceName);
        HashSet<String> metrics = Sets.newHashSet();
        if (segments == null || segments.isEmpty()) {
            return metrics;
        }
        if (interval == null || interval.isEmpty()) {
            DateTime now = this.getCurrentTime();
            theInterval = new Interval((ReadablePeriod)this.segmentMetadataQueryConfig.getDefaultHistory(), (ReadableInstant)now);
        } else {
            theInterval = new Interval((Object)interval);
        }
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            metrics.addAll(segment.getMetrics());
        }
        return metrics;
    }

    @GET
    @Path(value="/{dataSourceName}/candidates")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Iterable<LocatedSegmentDescriptor> getQueryTargets(@PathParam(value="dataSourceName") String datasource, @QueryParam(value="intervals") String intervals, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @Context HttpServletRequest req) throws IOException {
        ArrayList<Interval> intervalList = Lists.newArrayList();
        for (String interval : intervals.split(",")) {
            intervalList.add(Interval.parse((String)interval.trim()));
        }
        ArrayList<Interval> condensed = JodaUtils.condenseIntervals(intervalList);
        return ServerViewUtil.getTargetLocations(this.timelineServerView, datasource, condensed, numCandidates);
    }

    protected DateTime getCurrentTime() {
        return new DateTime();
    }
}

