/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;

public class VirtualizedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory baseFactory;
    private final VirtualColumns virtualColumns;

    public VirtualizedColumnSelectorFactory(ColumnSelectorFactory baseFactory, VirtualColumns virtualColumns) {
        this.baseFactory = Preconditions.checkNotNull(baseFactory, "baseFactory");
        this.virtualColumns = Preconditions.checkNotNull(virtualColumns, "virtualColumns");
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this.baseFactory);
        }
        return this.baseFactory.makeDimensionSelector(dimensionSpec);
    }

    @Override
    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeFloatColumnSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeFloatColumnSelector(columnName);
    }

    @Override
    public LongColumnSelector makeLongColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeLongColumnSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeLongColumnSelector(columnName);
    }

    @Override
    public DoubleColumnSelector makeDoubleColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeDoubleColumnSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeDoubleColumnSelector(columnName);
    }

    @Override
    @Nullable
    public ObjectColumnSelector makeObjectColumnSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeObjectColumnSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeObjectColumnSelector(columnName);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.baseFactory.getColumnCapabilities(columnName);
    }
}

