/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.LongColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedLongsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnSupplier;

public class LongGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static LongGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new LongGenericColumnPartSerde(byteOrder, null);
    }

    private LongGenericColumnPartSerde(ByteOrder byteOrder, ColumnPartSerde.Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                CompressedLongsIndexedSupplier column = CompressedLongsIndexedSupplier.fromByteBuffer(buffer, LongGenericColumnPartSerde.this.byteOrder, builder.getFileMapper());
                builder.setType(ValueType.LONG).setHasMultipleValues(false).setGenericColumn(new LongGenericColumnSupplier(column, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap()));
            }
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private LongColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(LongColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public LongGenericColumnPartSerde build() {
            return new LongGenericColumnPartSerde(this.byteOrder, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    delegate.writeToChannel(channel, smoosher);
                }
            });
        }
    }
}

