/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class LargeColumnSupportedComplexColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy strategy;
    private final int columnSize;
    private GenericIndexedWriter writer;

    public LargeColumnSupportedComplexColumnSerializer(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy) {
        this(ioPeon, filenameBase, strategy, Integer.MAX_VALUE);
    }

    public LargeColumnSupportedComplexColumnSerializer(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy, int columnSize) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
        this.columnSize = columnSize;
    }

    public static LargeColumnSupportedComplexColumnSerializer create(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy) {
        return new LargeColumnSupportedComplexColumnSerializer(ioPeon, filenameBase, strategy);
    }

    public static LargeColumnSupportedComplexColumnSerializer createWithColumnSize(IOPeon ioPeon, String filenameBase, ObjectStrategy strategy, int columnSize) {
        return new LargeColumnSupportedComplexColumnSerializer(ioPeon, filenameBase, strategy, columnSize);
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.ioPeon, StringUtils.format("%s.complex_column", this.filenameBase), this.strategy, this.columnSize);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        this.writer.write(obj);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeToChannel(channel, smoosher);
    }
}

