/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.joda.time.DateTime;

public class TimedShutoffFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(FirehoseFactory.class);
    private final FirehoseFactory delegateFactory;
    private final DateTime shutoffTime;

    @JsonCreator
    public TimedShutoffFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegateFactory, @JsonProperty(value="shutoffTime") DateTime shutoffTime) {
        this.delegateFactory = delegateFactory;
        this.shutoffTime = shutoffTime;
    }

    @Override
    public Firehose connect(InputRowParser parser, File temporaryDirectory) throws IOException {
        return new TimedShutoffFirehose(parser, temporaryDirectory);
    }

    @JsonProperty(value="delegate")
    public FirehoseFactory getDelegateFactory() {
        return this.delegateFactory;
    }

    @JsonProperty(value="shutoffTime")
    public DateTime getShutoffTime() {
        return this.shutoffTime;
    }

    class TimedShutoffFirehose
    implements Firehose {
        private final Firehose firehose;
        private final ScheduledExecutorService exec;
        private final Object shutdownLock = new Object();
        private volatile boolean shutdown = false;

        TimedShutoffFirehose(InputRowParser parser, File temporaryDirectory) throws IOException {
            this.firehose = TimedShutoffFirehoseFactory.this.delegateFactory.connect(parser, temporaryDirectory);
            this.exec = Execs.scheduledSingleThreaded("timed-shutoff-firehose-%d");
            this.exec.schedule(new Runnable(){

                @Override
                public void run() {
                    log.info("Closing delegate firehose.", new Object[0]);
                    TimedShutoffFirehose.this.shutdown = true;
                    try {
                        TimedShutoffFirehose.this.firehose.close();
                    }
                    catch (IOException e) {
                        log.warn(e, "Failed to close delegate firehose, ignoring.", new Object[0]);
                    }
                }
            }, TimedShutoffFirehoseFactory.this.shutoffTime.getMillis() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            log.info("Firehose created, will shut down at: %s", TimedShutoffFirehoseFactory.this.shutoffTime);
        }

        @Override
        public boolean hasMore() {
            return this.firehose.hasMore();
        }

        @Override
        public InputRow nextRow() {
            return this.firehose.nextRow();
        }

        @Override
        public Runnable commit() {
            return this.firehose.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.shutdownLock;
            synchronized (object) {
                if (!this.shutdown) {
                    this.shutdown = true;
                    this.firehose.close();
                }
            }
        }
    }
}

