/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;

public class FireHydrant {
    private final int count;
    private final Object swapLock = new Object();
    private volatile IncrementalIndex index;
    private volatile ReferenceCountingSegment adapter;

    public FireHydrant(IncrementalIndex index, int count, String segmentIdentifier) {
        this.index = index;
        this.adapter = new ReferenceCountingSegment(new IncrementalIndexSegment(index, segmentIdentifier));
        this.count = count;
    }

    public FireHydrant(Segment adapter, int count) {
        this.index = null;
        this.adapter = new ReferenceCountingSegment(adapter);
        this.count = count;
    }

    public IncrementalIndex getIndex() {
        return this.index;
    }

    public Segment getSegment() {
        return this.adapter;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapSegment(Segment newAdapter) {
        Object object = this.swapLock;
        synchronized (object) {
            if (this.adapter != null && newAdapter != null && !newAdapter.getIdentifier().equals(this.adapter.getIdentifier())) {
                throw new ISE("WTF?! Cannot swap identifier[%s] -> [%s]!", this.adapter.getIdentifier(), newAdapter.getIdentifier());
            }
            if (this.adapter != null) {
                try {
                    this.adapter.close();
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
            this.adapter = new ReferenceCountingSegment(newAdapter);
            this.index = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Segment, Closeable> getAndIncrementSegment() {
        Object object = this.swapLock;
        synchronized (object) {
            Closeable closeable = this.adapter.increment();
            return new Pair<Segment, Closeable>(this.adapter, closeable);
        }
    }

    public String toString() {
        return "FireHydrant{index=" + this.index + ", queryable=" + this.adapter.getIdentifier() + ", count=" + this.count + '}';
    }
}

