/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.segment.loading.SegmentizerFactory;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class MMappedQueryableSegmentizerFactory
implements SegmentizerFactory {
    private static final Logger log = new Logger(MMappedQueryableSegmentizerFactory.class);
    private final IndexIO indexIO;

    public MMappedQueryableSegmentizerFactory(@JacksonInject IndexIO indexIO) {
        this.indexIO = Preconditions.checkNotNull(indexIO, "Null IndexIO");
    }

    @Override
    public Segment factorize(DataSegment dataSegment, File parentDir) throws SegmentLoadingException {
        try {
            return new QueryableIndexSegment(dataSegment.getIdentifier(), this.indexIO.loadIndex(parentDir));
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "%s", e.getMessage());
        }
    }
}

