/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.CompressionUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.SegmentUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(LocalDataSegmentPusher.class);
    private final LocalDataSegmentPusherConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public LocalDataSegmentPusher(LocalDataSegmentPusherConfig config, ObjectMapper jsonMapper) {
        this.config = config;
        this.jsonMapper = jsonMapper;
        log.info("Configured local filesystem as deep storage", new Object[0]);
    }

    @Override
    public String getPathForHadoop() {
        return this.config.getStorageDirectory().getAbsoluteFile().toURI().toString();
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    @Override
    public DataSegment push(File dataSegmentFile, DataSegment segment) throws IOException {
        String storageDir = this.getStorageDir(segment);
        File baseStorageDir = this.config.getStorageDirectory();
        File outDir = new File(baseStorageDir, storageDir);
        log.info("Copying segment[%s] to local filesystem at location[%s]", segment.getIdentifier(), outDir.toString());
        if (dataSegmentFile.equals(outDir)) {
            long size = 0L;
            for (File file : dataSegmentFile.listFiles()) {
                size += file.length();
            }
            return this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outDir.toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile)), outDir);
        }
        File tmpOutDir = new File(baseStorageDir, this.intermediateDirFor(storageDir));
        log.info("Creating intermediate directory[%s] for segment[%s]", tmpOutDir.toString(), segment.getIdentifier());
        long size = this.compressSegment(dataSegmentFile, tmpOutDir);
        DataSegment dataSegment = this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(new File(outDir, "index.zip").toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile)), tmpOutDir);
        FileUtils.forceMkdir((File)outDir.getParentFile());
        try {
            Files.move(tmpOutDir.toPath(), outDir.toPath(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException e) {
            log.warn("Push destination directory[%s] exists, ignore this message if replication is configured.", outDir);
            FileUtils.deleteDirectory((File)tmpOutDir);
            return this.jsonMapper.readValue(new File(outDir, "descriptor.json"), DataSegment.class);
        }
        return dataSegment;
    }

    @Override
    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of("type", "local", "path", finalIndexZipFilePath.getPath());
    }

    private String intermediateDirFor(String storageDir) {
        return "intermediate_pushes/" + storageDir + "." + UUID.randomUUID().toString();
    }

    private long compressSegment(File dataSegmentFile, File outDir) throws IOException {
        FileUtils.forceMkdir((File)outDir);
        File outFile = new File(outDir, "index.zip");
        log.info("Compressing files from[%s] to [%s]", dataSegmentFile, outFile);
        return CompressionUtils.zip(dataSegmentFile, outFile);
    }

    private DataSegment createDescriptorFile(DataSegment segment, File outDir) throws IOException {
        File descriptorFile = new File(outDir, "descriptor.json");
        log.info("Creating descriptor file at[%s]", descriptorFile);
        Files.write(descriptorFile.toPath(), this.jsonMapper.writeValueAsBytes(segment), new OpenOption[0]);
        return segment;
    }
}

