/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public interface DataSegmentPusher {
    public static final Joiner JOINER = Joiner.on("/").skipNulls();

    @Deprecated
    public String getPathForHadoop(String var1);

    public String getPathForHadoop();

    public DataSegment push(File var1, DataSegment var2) throws IOException;

    public Map<String, Object> makeLoadSpec(URI var1);

    default public String getStorageDir(DataSegment dataSegment) {
        return DataSegmentPusher.getDefaultStorageDir(dataSegment);
    }

    default public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format("./%s/%s", this.getStorageDir(dataSegment), indexName);
    }

    default public List<String> getAllowedPropertyPrefixesForHadoop() {
        return Collections.emptyList();
    }

    public static String getDefaultStorageDir(DataSegment segment) {
        return JOINER.join(segment.getDataSource(), StringUtils.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), segment.getVersion(), segment.getShardSpec().getPartitionNum());
    }
}

