/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.indexing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private final String dataSource;
    private final Map<String, Object> parser;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="parser") Map<String, Object> parser, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JacksonInject ObjectMapper jsonMapper) {
        this.jsonMapper = Preconditions.checkNotNull(jsonMapper, "null ObjectMapper.");
        this.dataSource = Preconditions.checkNotNull(dataSource, "dataSource cannot be null. Please provide a dataSource.");
        this.parser = parser;
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
        if (aggregators != null && aggregators.length != 0) {
            HashSet<String> names = new HashSet<String>();
            for (AggregatorFactory factory : aggregators) {
                if (names.add(factory.getName())) continue;
                throw new IAE("duplicate aggregators found with name [%s].", factory.getName());
            }
        } else if (this.granularitySpec.isRollup()) {
            log.warn("No metricsSpec has been specified. Are you sure this is what you want?", new Object[0]);
        }
        this.aggregators = aggregators;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="parser")
    public Map<String, Object> getParserMap() {
        return this.parser;
    }

    @JsonIgnore
    public InputRowParser getParser() {
        if (this.parser == null) {
            log.warn("No parser has been specified", new Object[0]);
            return null;
        }
        InputRowParser inputRowParser = this.jsonMapper.convertValue(this.parser, InputRowParser.class);
        HashSet<String> dimensionExclusions = Sets.newHashSet();
        for (AggregatorFactory aggregatorFactory : this.aggregators) {
            dimensionExclusions.addAll(aggregatorFactory.requiredFields());
            dimensionExclusions.add(aggregatorFactory.getName());
        }
        if (inputRowParser.getParseSpec() != null) {
            DimensionsSpec dimensionsSpec = inputRowParser.getParseSpec().getDimensionsSpec();
            TimestampSpec timestampSpec = inputRowParser.getParseSpec().getTimestampSpec();
            if (timestampSpec != null) {
                String timestampColumn = timestampSpec.getTimestampColumn();
                if (!dimensionsSpec.hasCustomDimensions() || !dimensionsSpec.getDimensionNames().contains(timestampColumn)) {
                    dimensionExclusions.add(timestampColumn);
                }
            }
            if (dimensionsSpec != null) {
                HashSet<String> metSet = Sets.newHashSet();
                for (AggregatorFactory aggregator : this.aggregators) {
                    metSet.add(aggregator.getName());
                }
                HashSet<String> hashSet = Sets.newHashSet(dimensionsSpec.getDimensionNames());
                Sets.SetView overlap = Sets.intersection(metSet, hashSet);
                if (!overlap.isEmpty()) {
                    throw new IAE("Cannot have overlapping dimensions and metrics of the same name. Please change the name of the metric. Overlap: %s", overlap);
                }
                return inputRowParser.withParseSpec(inputRowParser.getParseSpec().withDimensionsSpec(dimensionsSpec.withDimensionExclusions(Sets.difference(dimensionExclusions, hashSet))));
            }
            return inputRowParser;
        }
        log.warn("No parseSpec in parser has been specified.", new Object[0]);
        return inputRowParser;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.parser, this.aggregators, granularitySpec, this.jsonMapper);
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + '\'' + ", parser=" + this.parser + ", aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + this.granularitySpec + '}';
    }
}

