/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;

public class OnheapIncrementalIndex
extends IncrementalIndex<Aggregator> {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private String outOfRowsReason = null;

    OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean concurrentEventAdd, boolean sortFacts, int maxRowCount) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions, concurrentEventAdd);
        this.maxRowCount = maxRowCount;
        this.facts = incrementalIndexSchema.isRollup() ? new IncrementalIndex.RollupFactsHolder(sortFacts, this.dimsComparator(), this.getDimensions()) : new IncrementalIndex.PlainFactsHolder(sortFacts);
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    protected Aggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics, boolean concurrentEventAdd) {
        this.selectors = Maps.newHashMap();
        for (AggregatorFactory agg : metrics) {
            this.selectors.put(agg.getName(), new ObjectCachingColumnSelectorFactory(this.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics), concurrentEventAdd));
        }
        return new Aggregator[metrics.length];
    }

    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
        int priorIndex = this.facts.getPriorIndex(key);
        if (-1 != priorIndex) {
            Aggregator[] aggs = this.concurrentGet(priorIndex);
            this.doAggregate(metrics, aggs, rowContainer, row, reportParseExceptions);
        } else {
            Aggregator[] aggs = new Aggregator[metrics.length];
            this.factorizeAggs(metrics, aggs, rowContainer, row);
            this.doAggregate(metrics, aggs, rowContainer, row, reportParseExceptions);
            Integer rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (numEntries.get() >= this.maxRowCount && this.facts.getPriorIndex(key) == -1) {
                throw new IndexSizeExceededException("Maximum number of rows [%d] reached", this.maxRowCount);
            }
            int prev = this.facts.putIfAbsent(key, rowIndex);
            if (-1 == prev) {
                numEntries.incrementAndGet();
            } else {
                aggs = this.concurrentGet(prev);
                this.doAggregate(metrics, aggs, rowContainer, row, reportParseExceptions);
                this.concurrentRemove(rowIndex);
            }
        }
        return numEntries.get();
    }

    @Override
    public int getLastRowIndex() {
        return this.indexIncrement.get() - 1;
    }

    private void factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row) {
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            aggs[i] = agg.factorize(this.selectors.get(agg.getName()));
        }
        rowContainer.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAggregate(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row, boolean reportParseExceptions) {
        rowContainer.set(row);
        for (int i = 0; i < aggs.length; ++i) {
            Aggregator agg;
            Aggregator aggregator = agg = aggs[i];
            synchronized (aggregator) {
                try {
                    agg.aggregate();
                }
                catch (ParseException e) {
                    if (reportParseExceptions) {
                        throw new ParseException(e, "Encountered parse error for aggregator[%s]", metrics[i].getName());
                    }
                    log.debug(e, "Encountered parse error, skipping aggregator[%s].", metrics[i].getName());
                }
                continue;
            }
        }
        rowContainer.set(null);
    }

    private void closeAggregators() {
        Closer closer = Closer.create();
        for (Aggregator[] aggs : this.aggregators.values()) {
            for (Aggregator agg : aggs) {
                closer.register(agg);
            }
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    protected void concurrentRemove(int offset) {
        this.aggregators.remove(offset);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    protected Object getAggVal(Aggregator agg, int rowOffset, int aggPosition) {
        return agg.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getLong();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].get();
    }

    @Override
    protected double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getDouble();
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].isNull();
    }

    @Override
    public void close() {
        super.close();
        this.closeAggregators();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
    }

    static class ObjectCachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final Map<String, LongColumnSelector> longColumnSelectorMap;
        private final Map<String, FloatColumnSelector> floatColumnSelectorMap;
        private final Map<String, ObjectColumnSelector> objectColumnSelectorMap;
        private final Map<String, DoubleColumnSelector> doubleColumnSelectorMap;
        private final ColumnSelectorFactory delegate;

        public ObjectCachingColumnSelectorFactory(ColumnSelectorFactory delegate, boolean concurrentEventAdd) {
            this.delegate = delegate;
            if (concurrentEventAdd) {
                this.longColumnSelectorMap = new ConcurrentHashMap<String, LongColumnSelector>();
                this.floatColumnSelectorMap = new ConcurrentHashMap<String, FloatColumnSelector>();
                this.objectColumnSelectorMap = new ConcurrentHashMap<String, ObjectColumnSelector>();
                this.doubleColumnSelectorMap = new ConcurrentHashMap<String, DoubleColumnSelector>();
            } else {
                this.longColumnSelectorMap = new HashMap<String, LongColumnSelector>();
                this.floatColumnSelectorMap = new HashMap<String, FloatColumnSelector>();
                this.objectColumnSelectorMap = new HashMap<String, ObjectColumnSelector>();
                this.doubleColumnSelectorMap = new HashMap<String, DoubleColumnSelector>();
            }
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
            FloatColumnSelector existing = this.floatColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            return this.floatColumnSelectorMap.computeIfAbsent(columnName, this.delegate::makeFloatColumnSelector);
        }

        @Override
        public LongColumnSelector makeLongColumnSelector(String columnName) {
            LongColumnSelector existing = this.longColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            return this.longColumnSelectorMap.computeIfAbsent(columnName, this.delegate::makeLongColumnSelector);
        }

        @Override
        public ObjectColumnSelector makeObjectColumnSelector(String columnName) {
            ObjectColumnSelector existing = this.objectColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            return this.objectColumnSelectorMap.computeIfAbsent(columnName, this.delegate::makeObjectColumnSelector);
        }

        @Override
        public DoubleColumnSelector makeDoubleColumnSelector(String columnName) {
            DoubleColumnSelector existing = this.doubleColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            return this.doubleColumnSelectorMap.computeIfAbsent(columnName, this.delegate::makeDoubleColumnSelector);
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return this.delegate.getColumnCapabilities(columnName);
        }
    }
}

