/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class SelectorFilter
implements Filter {
    private final String dimension;
    private final String value;

    public SelectorFilter(String dimension, String value) {
        this.dimension = dimension;
        this.value = value;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapDimensionValue(selector.getBitmapIndex(this.dimension, this.value));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.value);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return (double)indexSelector.getBitmapIndex(this.dimension, this.value).size() / (double)indexSelector.getNumRows();
    }

    public String toString() {
        return StringUtils.format("%s = %s", this.dimension, this.value);
    }
}

