/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.BooleanFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.IntIteratorUtils;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.filter.AndFilter;
import org.apache.hive.druid.io.druid.segment.filter.NotFilter;
import org.apache.hive.druid.io.druid.segment.filter.OrFilter;

public class Filters {
    public static final List<ValueType> FILTERABLE_TYPES = ImmutableList.of(ValueType.STRING, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE);
    private static final String CTX_KEY_USE_FILTER_CNF = "useFilterCNF";

    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return ImmutableList.copyOf(FunctionalIterable.create(dimFilters).transform(new Function<DimFilter, Filter>(){

            @Override
            public Filter apply(DimFilter input) {
                return input.toFilter();
            }
        }));
    }

    public static Filter toFilter(DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toFilter();
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, String value) {
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), value);
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, DruidPredicateFactory predicateFactory) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(columnName);
        if (capabilities != null && capabilities.getType() == ValueType.LONG) {
            return Filters.getLongPredicateMatcher(columnSelectorFactory.makeLongColumnSelector(columnName), predicateFactory.makeLongPredicate());
        }
        ColumnSelectorPlus<ValueMatcherColumnSelectorStrategy> selector = DimensionHandlerUtils.createColumnSelectorPlus(ValueMatcherColumnSelectorStrategyFactory.instance(), DefaultDimensionSpec.of(columnName), columnSelectorFactory);
        return selector.getColumnSelectorStrategy().makeValueMatcher(selector.getSelector(), predicateFactory);
    }

    public static ImmutableBitmap allFalse(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().makeEmptyImmutableBitmap();
    }

    public static ImmutableBitmap allTrue(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
    }

    static Iterable<ImmutableBitmap> bitmapsFromIndexes(final IntIterable indexes, final BitmapIndex bitmapIndex) {
        return new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                final IntIterator iterator = indexes.iterator();
                return new Iterator<ImmutableBitmap>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return bitmapIndex.getBitmap(iterator.nextInt());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T matchPredicate(String dimension, BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, Predicate<String> predicate) {
        return bitmapResultFactory.unionDimensionValueBitmaps(Filters.matchPredicateNoUnion(dimension, selector, predicate));
    }

    public static Iterable<ImmutableBitmap> matchPredicateNoUnion(String dimension, BitmapIndexSelector selector, Predicate<String> predicate) {
        Preconditions.checkNotNull(dimension, "dimension");
        Preconditions.checkNotNull(selector, "selector");
        Preconditions.checkNotNull(predicate, "predicate");
        Indexed<String> dimValues = selector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            return ImmutableList.of(predicate.apply(null) ? Filters.allTrue(selector) : Filters.allFalse(selector));
        }
        BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
        return Filters.makePredicateQualifyingBitmapIterable(bitmapIndex, predicate, dimValues);
    }

    public static double estimateSelectivity(String dimension, BitmapIndexSelector indexSelector, Predicate<String> predicate) {
        Preconditions.checkNotNull(dimension, "dimension");
        Preconditions.checkNotNull(indexSelector, "selector");
        Preconditions.checkNotNull(predicate, "predicate");
        Indexed<String> dimValues = indexSelector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            return predicate.apply(null) ? 1.0 : 0.0;
        }
        BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(dimension);
        return Filters.estimateSelectivity(bitmapIndex, IntIteratorUtils.toIntList(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues).iterator()), indexSelector.getNumRows());
    }

    public static double estimateSelectivity(BitmapIndex bitmapIndex, IntList bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        for (int i = 0; i < bitmaps.size(); ++i) {
            ImmutableBitmap bitmap = bitmapIndex.getBitmap(bitmaps.get(i));
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    public static double estimateSelectivity(Iterator<ImmutableBitmap> bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        while (bitmaps.hasNext()) {
            ImmutableBitmap bitmap = bitmaps.next();
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    private static Iterable<ImmutableBitmap> makePredicateQualifyingBitmapIterable(BitmapIndex bitmapIndex, Predicate<String> predicate, Indexed<String> dimValues) {
        return Filters.bitmapsFromIndexes(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues), bitmapIndex);
    }

    private static IntIterable makePredicateQualifyingIndexIterable(final BitmapIndex bitmapIndex, final Predicate<String> predicate, final Indexed<String> dimValues) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    private final int bitmapIndexCardinality;
                    private int nextIndex;
                    private int found;
                    {
                        this.bitmapIndexCardinality = bitmapIndex.getCardinality();
                        this.nextIndex = 0;
                        this.found = -1;
                        this.found = this.findNextIndex();
                    }

                    private int findNextIndex() {
                        while (this.nextIndex < this.bitmapIndexCardinality && !predicate.apply(dimValues.get(this.nextIndex))) {
                            ++this.nextIndex;
                        }
                        if (this.nextIndex < this.bitmapIndexCardinality) {
                            return this.nextIndex++;
                        }
                        return -1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    @Override
                    public int nextInt() {
                        int foundIndex = this.found;
                        if (foundIndex == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNextIndex();
                        return foundIndex;
                    }
                };
            }
        };
    }

    static boolean supportsSelectivityEstimation(Filter filter, String dimension, ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        Column column;
        if (filter.supportsBitmapIndex(indexSelector) && (column = columnSelector.getColumn(dimension)) != null) {
            return !column.getCapabilities().hasMultipleValues();
        }
        return false;
    }

    public static ValueMatcher getLongPredicateMatcher(final LongColumnSelector longSelector, final DruidLongPredicate predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyLong(longSelector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("longSelector", longSelector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static Filter convertToCNFFromQueryContext(Query query, Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.getContextBoolean(CTX_KEY_USE_FILTER_CNF, false);
        return useCNF ? Filters.convertToCNF(filter) : filter;
    }

    public static Filter convertToCNF(Filter current) {
        current = Filters.pushDownNot(current);
        current = Filters.flatten(current);
        current = Filters.convertToCNFInternal(current);
        current = Filters.flatten(current);
        return current;
    }

    private static Filter pushDownNot(Filter current) {
        ArrayList<Filter> children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return Filters.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                ArrayList<Filter> children2 = Lists.newArrayList();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new OrFilter(children2);
            }
            if (child instanceof OrFilter) {
                ArrayList<Filter> children3 = Lists.newArrayList();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(Filters.pushDownNot(new NotFilter(grandChild)));
                }
                return new AndFilter(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            children = Lists.newArrayList();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(Filters.pushDownNot(child));
            }
            return new OrFilter(children);
        }
        return current;
    }

    private static Filter convertToCNFInternal(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(Filters.convertToCNFInternal(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            ArrayList<Filter> children = Lists.newArrayList();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(Filters.convertToCNFInternal(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    for (Filter grandChild : ((OrFilter)child).getFilters()) {
                        nonAndList.add(grandChild);
                    }
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                ArrayList<Filter> result = Lists.newArrayList();
                Filters.generateAllCombinations(result, andList, nonAndList);
                return new AndFilter(result);
            }
        }
        return current;
    }

    private static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>();
            children.addAll(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = Filters.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    List<Filter> grandKids = ((BooleanFilter)child).getFilters();
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(List<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        List<Filter> children = ((AndFilter)andList.get(0)).getFilters();
        if (result.isEmpty()) {
            for (Filter child : children) {
                ArrayList<Filter> a = Lists.newArrayList(nonAndList);
                a.add(child);
                result.add(new OrFilter(a));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    ArrayList<Filter> a = Lists.newArrayList(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(new OrFilter(a));
                }
            }
        }
        if (andList.size() > 1) {
            Filters.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }
}

