/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;

public class TmpFileIOPeon
implements IOPeon {
    private final File dir;
    private final boolean allowOverwrite;
    private final Map<String, File> createdFiles = Maps.newLinkedHashMap();

    public TmpFileIOPeon() {
        this(true);
    }

    public TmpFileIOPeon(boolean allowOverwrite) {
        this(null, allowOverwrite);
    }

    public TmpFileIOPeon(File dir, boolean allowOverwrite) {
        this.dir = dir;
        this.allowOverwrite = allowOverwrite;
    }

    @Override
    public OutputStream makeOutputStream(String filename) throws IOException {
        File retFile = this.createdFiles.get(filename);
        if (retFile == null) {
            retFile = File.createTempFile("filePeon", filename, this.dir);
            this.createdFiles.put(filename, retFile);
            return new BufferedOutputStream(new FileOutputStream(retFile));
        }
        if (this.allowOverwrite) {
            return new BufferedOutputStream(new FileOutputStream(retFile));
        }
        throw new IOException("tmp file conflicts, file[" + filename + "] already exist!");
    }

    @Override
    public InputStream makeInputStream(String filename) throws IOException {
        File retFile = this.createdFiles.get(filename);
        return retFile == null ? null : new FileInputStream(retFile);
    }

    @Override
    public void close() throws IOException {
        for (File file : this.createdFiles.values()) {
            file.delete();
        }
        this.createdFiles.clear();
    }

    public boolean isOverwriteAllowed() {
        return this.allowOverwrite;
    }

    @Override
    public File getFile(String filename) {
        return this.createdFiles.get(filename);
    }
}

