/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class RoaringBitmapSerdeFactory
implements BitmapSerdeFactory {
    private static final boolean DEFAULT_COMPRESS_RUN_ON_SERIALIZATION = true;
    private static final ObjectStrategy<ImmutableBitmap> objectStrategy = new ImmutableRoaringBitmapObjectStrategy();
    private final boolean compressRunOnSerialization;
    private final BitmapFactory bitmapFactory;
    private static Ordering<WrappedImmutableRoaringBitmap> roaringComparator = new Ordering<WrappedImmutableRoaringBitmap>(){

        @Override
        public int compare(WrappedImmutableRoaringBitmap set1, WrappedImmutableRoaringBitmap set2) {
            if (set1.size() == 0 && set2.size() == 0) {
                return 0;
            }
            if (set1.size() == 0) {
                return -1;
            }
            if (set2.size() == 0) {
                return 1;
            }
            return set1.compareTo(set2);
        }
    }.nullsFirst();

    @JsonCreator
    public RoaringBitmapSerdeFactory(@JsonProperty(value="compressRunOnSerialization") Boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization == null ? true : compressRunOnSerialization;
        this.bitmapFactory = new RoaringBitmapFactory(this.compressRunOnSerialization);
    }

    @JsonProperty
    public boolean getCompressRunOnSerialization() {
        return this.compressRunOnSerialization;
    }

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return objectStrategy;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    public String toString() {
        return "RoaringBitmapSerdeFactory{}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RoaringBitmapSerdeFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static class ImmutableRoaringBitmapObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableRoaringBitmapObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        public ImmutableBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            if (numBytes == 0) {
                return null;
            }
            buffer.limit(buffer.position() + numBytes);
            return new WrappedImmutableRoaringBitmap(new ImmutableRoaringBitmap(buffer));
        }

        @Override
        public byte[] toBytes(ImmutableBitmap val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            return roaringComparator.compare((WrappedImmutableRoaringBitmap)o1, (WrappedImmutableRoaringBitmap)o2);
        }
    }
}

