/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.math.LongMath;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.BlockLayoutLongSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.DeltaLongEncodingWriter;
import org.apache.hive.druid.io.druid.segment.data.EntireLayoutLongSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.LongSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.LongsLongEncodingWriter;
import org.apache.hive.druid.io.druid.segment.data.TableLongEncodingWriter;

public class IntermediateLongSupplierSerializer
implements LongSupplierSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final String tempFile;
    private final ByteOrder order;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private CountingOutputStream tempOut = null;
    private final ByteBuffer helperBuffer = ByteBuffer.allocate(8);
    private int numInserted = 0;
    private final Long2IntMap uniqueValues = new Long2IntOpenHashMap();
    private final LongList valuesAddedInOrder = new LongArrayList();
    private long maxVal = Long.MIN_VALUE;
    private long minVal = Long.MAX_VALUE;
    private LongSupplierSerializer delegate;

    public IntermediateLongSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.tempFile = filenameBase + ".temp";
        this.filenameBase = filenameBase;
        this.order = order;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.tempOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.tempFile));
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        SerializerUtils.writeBigEndianLongToOutputStream(this.tempOut, value, this.helperBuffer);
        ++this.numInserted;
        if (this.uniqueValues.size() <= 256 && !this.uniqueValues.containsKey(value)) {
            this.uniqueValues.put(value, this.uniqueValues.size());
            this.valuesAddedInOrder.add(value);
        }
        if (value > this.maxVal) {
            this.maxVal = value;
        }
        if (value < this.minVal) {
            this.minVal = value;
        }
    }

    private void makeDelegate() throws IOException {
        long delta;
        try {
            delta = LongMath.checkedSubtract(this.maxVal, this.minVal);
        }
        catch (ArithmeticException e) {
            delta = -1L;
        }
        CompressionFactory.LongEncodingWriter writer = this.uniqueValues.size() <= 256 ? new TableLongEncodingWriter(this.uniqueValues, this.valuesAddedInOrder) : (delta != -1L && delta != Long.MAX_VALUE ? new DeltaLongEncodingWriter(this.minVal, delta) : new LongsLongEncodingWriter(this.order));
        this.delegate = this.compression == CompressedObjectStrategy.CompressionStrategy.NONE ? new EntireLayoutLongSupplierSerializer(this.ioPeon, this.filenameBase, this.order, writer) : new BlockLayoutLongSupplierSerializer(this.ioPeon, this.filenameBase, this.order, writer, this.compression);
        try (DataInputStream tempIn = new DataInputStream(new BufferedInputStream(this.ioPeon.makeInputStream(this.tempFile)));){
            this.delegate.open();
            for (int available = this.numInserted; available > 0; --available) {
                this.delegate.add(tempIn.readLong());
            }
        }
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.tempOut.close();
        this.makeDelegate();
        this.delegate.closeAndConsolidate(consolidatedOut);
    }

    @Override
    public void close() throws IOException {
        this.tempOut.close();
        this.makeDelegate();
        this.delegate.close();
    }

    @Override
    public long getSerializedSize() {
        return this.delegate.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.delegate.writeToChannel(channel, smoosher);
    }
}

