/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.segment.data.IndexedDoubles;

public class EntireLayoutIndexedDoubleSupplier
implements Supplier<IndexedDoubles> {
    private final int totalSize;
    private final DoubleBuffer buffer;

    public EntireLayoutIndexedDoubleSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder byteOrder) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(byteOrder).asDoubleBuffer();
    }

    @Override
    public IndexedDoubles get() {
        return new EntireLayoutIndexedDoubles();
    }

    private class EntireLayoutIndexedDoubles
    implements IndexedDoubles {
        private EntireLayoutIndexedDoubles() {
        }

        @Override
        public int size() {
            return EntireLayoutIndexedDoubleSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            return EntireLayoutIndexedDoubleSupplier.this.buffer.get(EntireLayoutIndexedDoubleSupplier.this.buffer.position() + index);
        }

        @Override
        public void fill(int index, double[] toFill) {
            if (EntireLayoutIndexedDoubleSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, EntireLayoutIndexedDoubleSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "EntireCompressedIndexedDoubles_Anonymous{, totalSize=" + EntireLayoutIndexedDoubleSupplier.this.totalSize + '}';
        }
    }
}

