/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.DoubleSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;

public class EntireLayoutDoubleSupplierSerializer
implements DoubleSupplierSerializer {
    private final IOPeon ioPeon;
    private final String valueFile;
    private final String metaFile;
    private CountingOutputStream valuesOut;
    private long metaCount = 0L;
    private final ByteBuffer orderBuffer;
    private int numInserted = 0;

    public EntireLayoutDoubleSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order) {
        this.ioPeon = ioPeon;
        this.valueFile = filenameBase + ".value";
        this.metaFile = filenameBase + ".format";
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.valueFile));
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(double value) throws IOException {
        this.orderBuffer.rewind();
        this.orderBuffer.putDouble(value);
        this.valuesOut.write(this.orderBuffer.array());
        ++this.numInserted;
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.close();
        try (OutputStream out = consolidatedOut.openStream();
             InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream value = this.ioPeon.makeInputStream(this.valueFile);){
            ByteStreams.copy(meta, out);
            ByteStreams.copy(value, out);
        }
    }

    @Override
    public long getSerializedSize() {
        return this.metaCount + this.valuesOut.getCount();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        try (InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream value = this.ioPeon.makeInputStream(this.valueFile);){
            ByteStreams.copy(Channels.newChannel(meta), channel);
            ByteStreams.copy(Channels.newChannel(value), channel);
        }
    }

    @Override
    public void close() throws IOException {
        this.valuesOut.close();
        try (CountingOutputStream metaOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.metaFile));){
            metaOut.write(2);
            metaOut.write(Ints.toByteArray(this.numInserted));
            metaOut.write(Ints.toByteArray(0));
            metaOut.write(CompressedObjectStrategy.CompressionStrategy.NONE.getId());
            metaOut.close();
            this.metaCount = metaOut.getCount();
        }
    }
}

