/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.CompressedByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.SingleValueIndexedIntsWriter;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;

public class CompressedVSizeIntsIndexedWriter
extends SingleValueIndexedIntsWriter {
    private static final byte VERSION = 2;
    private final int numBytes;
    private final int chunkFactor;
    private final int chunkBytes;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final GenericIndexedWriter<ResourceHolder<ByteBuffer>> flattener;
    private final ByteBuffer intBuffer;
    private ByteBuffer endBuffer;
    private int numInserted;

    public CompressedVSizeIntsIndexedWriter(IOPeon ioPeon, String filenameBase, int maxValue, int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this(ioPeon, filenameBase, maxValue, chunkFactor, byteOrder, compression, new GenericIndexedWriter<ResourceHolder<ByteBuffer>>(ioPeon, filenameBase, CompressedByteBufferObjectStrategy.getBufferForOrder(byteOrder, compression, CompressedVSizeIntsIndexedWriter.sizePer(maxValue, chunkFactor))));
    }

    public CompressedVSizeIntsIndexedWriter(IOPeon ioPeon, String filenameBase, int maxValue, int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression, GenericIndexedWriter writer) {
        this.numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
        this.chunkFactor = chunkFactor;
        this.chunkBytes = chunkFactor * this.numBytes + CompressedVSizeIntsIndexedSupplier.bufferPadding(this.numBytes);
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.flattener = writer;
        this.intBuffer = ByteBuffer.allocate(4).order(byteOrder);
        this.endBuffer = ByteBuffer.allocate(this.chunkBytes).order(byteOrder);
        this.endBuffer.limit(this.numBytes * chunkFactor);
        this.numInserted = 0;
    }

    public static CompressedVSizeIntsIndexedWriter create(IOPeon ioPeon, String filenameBase, int maxValue, CompressedObjectStrategy.CompressionStrategy compression) {
        return new CompressedVSizeIntsIndexedWriter(ioPeon, filenameBase, maxValue, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(maxValue), IndexIO.BYTE_ORDER, compression);
    }

    private static int sizePer(int maxValue, int chunkFactor) {
        return chunkFactor * VSizeIndexedInts.getNumBytesForMax(maxValue) + CompressedVSizeIntsIndexedSupplier.bufferPadding(VSizeIndexedInts.getNumBytesForMax(maxValue));
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    protected void addValue(int val) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write(StupidResourceHolder.create(this.endBuffer));
            this.endBuffer = ByteBuffer.allocate(this.chunkBytes).order(this.byteOrder);
            this.endBuffer.limit(this.numBytes * this.chunkFactor);
        }
        this.intBuffer.putInt(0, val);
        if (this.byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            this.endBuffer.put(this.intBuffer.array(), 4 - this.numBytes, this.numBytes);
        } else {
            this.endBuffer.put(this.intBuffer.array(), 0, this.numBytes);
        }
        ++this.numInserted;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.numInserted > 0) {
                this.endBuffer.limit(this.endBuffer.position());
                this.endBuffer.rewind();
                this.flattener.write(StupidResourceHolder.create(this.endBuffer));
            }
            this.endBuffer = null;
        }
        finally {
            this.flattener.close();
        }
    }

    @Override
    public long getSerializedSize() {
        return 11L + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.numInserted)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.chunkFactor)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        this.flattener.writeToChannel(channel, smoosher);
    }
}

