/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.io.Closeables;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.CompressedByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIntsIterator;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;

public class CompressedVSizeIntsIndexedSupplier
implements WritableSupplier<IndexedInts> {
    public static final byte VERSION = 2;
    private final int totalSize;
    private final int sizePer;
    private final int numBytes;
    private final int bigEndianShift;
    private final int littleEndianMask;
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseBuffers;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    CompressedVSizeIntsIndexedSupplier(int totalSize, int sizePer, int numBytes, GenericIndexed<ResourceHolder<ByteBuffer>> baseBuffers, CompressedObjectStrategy.CompressionStrategy compression) {
        Preconditions.checkArgument(sizePer == 1 << Integer.numberOfTrailingZeros(sizePer), "Number of entries per chunk must be a power of 2");
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseBuffers = baseBuffers;
        this.compression = compression;
        this.numBytes = numBytes;
        this.bigEndianShift = 32 - (numBytes << 3);
        this.littleEndianMask = (int)((1L << (numBytes << 3)) - 1L);
    }

    public static int maxIntsInBufferForBytes(int numBytes) {
        int maxSizePer = (65536 - CompressedVSizeIntsIndexedSupplier.bufferPadding(numBytes)) / numBytes;
        return 1 << 31 - Integer.numberOfLeadingZeros(maxSizePer);
    }

    public static int bufferPadding(int numBytes) {
        switch (numBytes) {
            case 1: 
            case 2: {
                return 0;
            }
        }
        return 4 - numBytes;
    }

    public static int maxIntsInBufferForValue(int maxValue) {
        return CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes(VSizeIndexedInts.getNumBytesForMax(maxValue));
    }

    public int size() {
        return this.totalSize;
    }

    @Override
    public IndexedInts get() {
        if (this.numBytes == 4) {
            return new CompressedFullSizeIndexedInts();
        }
        if (this.numBytes == 2) {
            return new CompressedShortSizeIndexedInts();
        }
        if (this.numBytes == 1) {
            return new CompressedByteSizeIndexedInts();
        }
        return new CompressedVSizeIndexedInts();
    }

    @Override
    public long getSerializedSize() {
        return 11L + this.baseBuffers.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        this.baseBuffers.writeToChannel(channel);
    }

    @VisibleForTesting
    GenericIndexed<ResourceHolder<ByteBuffer>> getBaseBuffers() {
        return this.baseBuffers;
    }

    public static CompressedVSizeIntsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order, SmooshedFileMapper fileMapper) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            byte numBytes = buffer.get();
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            int chunkBytes = sizePer * numBytes + CompressedVSizeIntsIndexedSupplier.bufferPadding(numBytes);
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.forId(buffer.get());
            return new CompressedVSizeIntsIndexedSupplier(totalSize, sizePer, numBytes, GenericIndexed.read(buffer, CompressedByteBufferObjectStrategy.getBufferForOrder(order, compression, chunkBytes), fileMapper), compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    public static CompressedVSizeIntsIndexedSupplier fromList(final List<Integer> list, int maxValue, final int chunkFactor, final ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        final byte numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
        final int chunkBytes = chunkFactor * numBytes + CompressedVSizeIntsIndexedSupplier.bufferPadding(numBytes);
        Preconditions.checkArgument(chunkFactor <= CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes(numBytes), "Chunks must be <= 64k bytes. chunkFactor was[%s]", chunkFactor);
        return new CompressedVSizeIntsIndexedSupplier(list.size(), chunkFactor, numBytes, GenericIndexed.fromIterable(new Iterable<ResourceHolder<ByteBuffer>>(){

            @Override
            public Iterator<ResourceHolder<ByteBuffer>> iterator() {
                return new Iterator<ResourceHolder<ByteBuffer>>(){
                    int position = 0;

                    @Override
                    public boolean hasNext() {
                        return this.position < list.size();
                    }

                    @Override
                    public ResourceHolder<ByteBuffer> next() {
                        ByteBuffer retVal = ByteBuffer.allocate(chunkBytes).order(byteOrder);
                        if (chunkFactor > list.size() - this.position) {
                            retVal.limit((list.size() - this.position) * numBytes);
                        } else {
                            retVal.limit(chunkFactor * numBytes);
                        }
                        List ints = list.subList(this.position, this.position + retVal.remaining() / numBytes);
                        ByteBuffer buf = ByteBuffer.allocate(4).order(byteOrder);
                        boolean bigEndian = byteOrder.equals(ByteOrder.BIG_ENDIAN);
                        Iterator iterator = ints.iterator();
                        while (iterator.hasNext()) {
                            int value = (Integer)iterator.next();
                            buf.putInt(0, value);
                            if (bigEndian) {
                                retVal.put(buf.array(), 4 - numBytes, numBytes);
                                continue;
                            }
                            retVal.put(buf.array(), 0, numBytes);
                        }
                        retVal.rewind();
                        this.position += retVal.remaining() / numBytes;
                        return StupidResourceHolder.create(retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedByteBufferObjectStrategy.getBufferForOrder(byteOrder, compression, chunkBytes)), compression);
    }

    private class CompressedVSizeIndexedInts
    implements IndexedInts {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedBuffers;
        final int div;
        final int rem;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        boolean bigEndian;

        private CompressedVSizeIndexedInts() {
            this.singleThreadedBuffers = CompressedVSizeIntsIndexedSupplier.this.baseBuffers.singleThreaded();
            this.div = Integer.numberOfTrailingZeros(CompressedVSizeIntsIndexedSupplier.this.sizePer);
            this.rem = CompressedVSizeIntsIndexedSupplier.this.sizePer - 1;
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return CompressedVSizeIntsIndexedSupplier.this.totalSize;
        }

        @Override
        public int get(int index) {
            int bufferNum = index >> this.div;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this._get(index & this.rem);
        }

        protected int _get(int index) {
            int pos = this.buffer.position() + index * CompressedVSizeIntsIndexedSupplier.this.numBytes;
            return this.bigEndian ? this.buffer.getInt(pos) >>> CompressedVSizeIntsIndexedSupplier.this.bigEndianShift : this.buffer.getInt(pos) & CompressedVSizeIntsIndexedSupplier.this.littleEndianMask;
        }

        @Override
        public IntIterator iterator() {
            return new IndexedIntsIterator(this);
        }

        @Override
        public void fill(int index, int[] toFill) {
            throw new UnsupportedOperationException("fill not supported");
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.currIndex = bufferNum;
            this.bigEndian = this.buffer.order().equals(ByteOrder.BIG_ENDIAN);
        }

        public String toString() {
            return "CompressedVSizedIntsIndexedSupplier{currIndex=" + this.currIndex + ", sizePer=" + CompressedVSizeIntsIndexedSupplier.this.sizePer + ", numChunks=" + this.singleThreadedBuffers.size() + ", totalSize=" + CompressedVSizeIntsIndexedSupplier.this.totalSize + '}';
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.holder, false);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("singleThreadedBuffers", this.singleThreadedBuffers);
        }
    }

    private class CompressedByteSizeIndexedInts
    extends CompressedVSizeIndexedInts {
        private CompressedByteSizeIndexedInts() {
        }

        @Override
        protected int _get(int index) {
            return this.buffer.get(this.buffer.position() + index) & 0xFF;
        }
    }

    private class CompressedShortSizeIndexedInts
    extends CompressedVSizeIndexedInts {
        ShortBuffer shortBuffer;

        private CompressedShortSizeIndexedInts() {
        }

        @Override
        protected void loadBuffer(int bufferNum) {
            super.loadBuffer(bufferNum);
            this.shortBuffer = this.buffer.asShortBuffer();
        }

        @Override
        protected int _get(int index) {
            return this.shortBuffer.get(this.shortBuffer.position() + index) & 0xFFFF;
        }
    }

    private class CompressedFullSizeIndexedInts
    extends CompressedVSizeIndexedInts {
        IntBuffer intBuffer;

        private CompressedFullSizeIndexedInts() {
        }

        @Override
        protected void loadBuffer(int bufferNum) {
            super.loadBuffer(bufferNum);
            this.intBuffer = this.buffer.asIntBuffer();
        }

        @Override
        protected int _get(int index) {
            return this.intBuffer.get(this.intBuffer.position() + index);
        }
    }
}

