/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.FixedSizeCompressedObjectStrategy;

public class CompressedFloatBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<FloatBuffer> {
    public static CompressedFloatBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedFloatBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedFloatBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<FloatBuffer>(){

            @Override
            public FloatBuffer convert(ByteBuffer buf) {
                return buf.asFloatBuffer();
            }

            @Override
            public int compare(FloatBuffer lhs, FloatBuffer rhs) {
                return Comparators.naturalNullsFirst().compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 4;
            }

            @Override
            public FloatBuffer combine(ByteBuffer into, FloatBuffer from) {
                return into.asFloatBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

