/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IndexedDoubles;

public class CompressedDoublesIndexedSupplier
implements Supplier<IndexedDoubles> {
    public static final byte LZF_VERSION = 1;
    public static final byte version = 2;
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<IndexedDoubles> supplier;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    public CompressedDoublesIndexedSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<IndexedDoubles> supplier, CompressedObjectStrategy.CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
    }

    @Override
    public IndexedDoubles get() {
        return this.supplier.get();
    }

    public static CompressedDoublesIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order, SmooshedFileMapper mapper) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressedObjectStrategy.CompressionStrategy.forId(compressionId);
            }
            Supplier<IndexedDoubles> supplier = CompressionFactory.getDoubleSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression, mapper);
            return new CompressedDoublesIndexedSupplier(totalSize, sizePer, buffer, supplier, compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    public int size() {
        return this.totalSize;
    }

    public long getSerializedSize() {
        return this.buffer.remaining() + 1 + 4 + 4 + 1;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        channel.write(this.buffer.asReadOnlyBuffer());
    }
}

