/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class ByteBufferSerializer<T> {
    @Nullable
    public static <T> T read(ByteBuffer buffer, ObjectStrategy<T> strategy) {
        int size = buffer.getInt();
        if (size < 0) {
            return null;
        }
        ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
        bufferToUse.limit(bufferToUse.position() + size);
        buffer.position(bufferToUse.limit());
        return strategy.fromByteBuffer(bufferToUse, size);
    }

    public static <T> void writeToChannel(@Nullable T obj, ObjectStrategy<T> strategy, WritableByteChannel channel) throws IOException {
        byte[] toWrite = strategy.toBytes(obj);
        int size = toWrite == null ? -1 : toWrite.length;
        channel.write(ByteBuffer.allocate(4).putInt(0, size));
        if (size > 0) {
            channel.write(ByteBuffer.wrap(toWrite));
        }
    }
}

