/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedLongs;
import org.apache.hive.druid.io.druid.segment.data.LongsLongEncodingReader;
import org.apache.hive.druid.io.druid.segment.data.VSizeCompressedObjectStrategy;

public class BlockLayoutIndexedLongSupplier
implements Supplier<IndexedLongs> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseLongBuffers;
    private final int totalSize;
    private final int sizePer;
    private final CompressionFactory.LongEncodingReader baseReader;

    public BlockLayoutIndexedLongSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionFactory.LongEncodingReader reader, CompressedObjectStrategy.CompressionStrategy strategy, SmooshedFileMapper fileMapper) {
        this.baseLongBuffers = GenericIndexed.read(fromBuffer, VSizeCompressedObjectStrategy.getBufferForOrder(order, strategy, reader.getNumBytes(sizePer)), fileMapper);
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseReader = reader;
    }

    @Override
    public IndexedLongs get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            if (this.baseReader instanceof LongsLongEncodingReader) {
                return new BlockLayoutIndexedLongs(){

                    @Override
                    public long get(int index) {
                        int bufferNum = index >> div;
                        if (bufferNum != this.currIndex) {
                            this.loadBuffer(bufferNum);
                        }
                        int bufferIndex = index & rem;
                        return this.longBuffer.get(this.longBuffer.position() + bufferIndex);
                    }

                    @Override
                    protected void loadBuffer(int bufferNum) {
                        CloseQuietly.close(this.holder);
                        this.holder = (ResourceHolder)this.singleThreadedLongBuffers.get(bufferNum);
                        this.buffer = (ByteBuffer)this.holder.get();
                        this.longBuffer = this.buffer.asLongBuffer();
                        this.currIndex = bufferNum;
                    }
                };
            }
            return new BlockLayoutIndexedLongs(){

                @Override
                public long get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.reader.read(bufferIndex);
                }
            };
        }
        return new BlockLayoutIndexedLongs();
    }

    private class BlockLayoutIndexedLongs
    implements IndexedLongs {
        final CompressionFactory.LongEncodingReader reader;
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedLongBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        LongBuffer longBuffer;

        private BlockLayoutIndexedLongs() {
            this.reader = BlockLayoutIndexedLongSupplier.this.baseReader.duplicate();
            this.singleThreadedLongBuffers = BlockLayoutIndexedLongSupplier.this.baseLongBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutIndexedLongSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            int bufferNum = index / BlockLayoutIndexedLongSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutIndexedLongSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.reader.read(bufferIndex);
        }

        @Override
        public void fill(int index, long[] toFill) {
            if (BlockLayoutIndexedLongSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutIndexedLongSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedLongBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.currIndex = bufferNum;
            this.reader.setBuffer(this.buffer);
        }

        public String toString() {
            return "BlockCompressedIndexedLongs_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutIndexedLongSupplier.this.sizePer + ", numChunks=" + this.singleThreadedLongBuffers.size() + ", totalSize=" + BlockLayoutIndexedLongSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }
    }
}

