/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.IntIteratorUtils;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public class BitmapCompressedIndexedInts
implements IndexedInts,
Comparable<ImmutableBitmap> {
    private static final Ordering<ImmutableBitmap> COMPARATOR = new Ordering<ImmutableBitmap>(){

        @Override
        public int compare(ImmutableBitmap set, ImmutableBitmap set1) {
            if (set.size() == 0 && set1.size() == 0) {
                return 0;
            }
            if (set.size() == 0) {
                return -1;
            }
            if (set1.size() == 0) {
                return 1;
            }
            return set.compareTo(set1);
        }
    }.nullsFirst();
    private final ImmutableBitmap immutableBitmap;

    public BitmapCompressedIndexedInts(ImmutableBitmap immutableBitmap) {
        this.immutableBitmap = immutableBitmap;
    }

    @Override
    public int compareTo(@Nullable ImmutableBitmap otherBitmap) {
        return COMPARATOR.compare(this.immutableBitmap, otherBitmap);
    }

    @Override
    public int size() {
        return this.immutableBitmap.size();
    }

    @Override
    public int get(int index) {
        throw new UnsupportedOperationException("This is really slow, so it's just not supported.");
    }

    public ImmutableBitmap getImmutableBitmap() {
        return this.immutableBitmap;
    }

    @Override
    public IntIterator iterator() {
        return IntIteratorUtils.fromRoaringBitmapIntIterator(this.immutableBitmap.iterator());
    }

    @Override
    public void fill(int index, int[] toFill) {
        throw new UnsupportedOperationException("fill not supported");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("immutableBitmap", this.immutableBitmap);
    }
}

