/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.io.IOException;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public final class ArrayBasedIndexedInts
implements IndexedInts {
    private static final ArrayBasedIndexedInts EMPTY = new ArrayBasedIndexedInts(IntArrays.EMPTY_ARRAY, 0);
    private final int[] expansion;
    private final int size;

    public static ArrayBasedIndexedInts of(int[] expansion) {
        if (expansion.length == 0) {
            return EMPTY;
        }
        return new ArrayBasedIndexedInts(expansion, expansion.length);
    }

    public static ArrayBasedIndexedInts of(int[] expansion, int size) {
        if (size == 0) {
            return EMPTY;
        }
        if (size < 0 || size > expansion.length) {
            throw new IAE("Size[%s] should be between 0 and %s", size, expansion.length);
        }
        return new ArrayBasedIndexedInts(expansion, size);
    }

    private ArrayBasedIndexedInts(int[] expansion, int size) {
        this.expansion = expansion;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }
        return this.expansion[index];
    }

    @Override
    public IntIterator iterator() {
        return IntIterators.wrap(this.expansion, 0, this.size);
    }

    @Override
    public void fill(int index, int[] toFill) {
        throw new UnsupportedOperationException("fill not supported");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

